package io.sendon.contacts.response;

import java.lang.reflect.Type;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;

public class GetBlocklist extends SendonResponse {
  public GetBlocklistData data;

  public static class BlocklistItem {
    public int userId;
    public String phoneNumber;
    public int blockId;
    public String blockType;
    public String createdAt;
    public String updatedAt;
  }

  public static class GetBlocklistData {
    public int cursor;
    public int totalCount;
    public List<BlocklistItem> blocklist;
  }

  public GetBlocklist(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    Type type = new TypeToken<GetBlocklistData>(){}.getType();
    this.data = new Gson().fromJson(sendonJsonResponse.dataJson, type);
  }
}
