package io.sendon.base;

import okhttp3.*;

import java.io.File;
import java.io.IOException;
import java.util.List;

public class SquareupOkHttpClient extends HttpClient {
  private final OkHttpClient client;
  private static final MediaType JSON = MediaType.get("application/json; charset=utf-8");

  public SquareupOkHttpClient(String baseUrl, String id, String pw) {
    super(baseUrl, id, pw);

    this.client = new OkHttpClient.Builder()
        .connectTimeout(30, java.util.concurrent.TimeUnit.SECONDS)
        .readTimeout(30, java.util.concurrent.TimeUnit.SECONDS)
        .writeTimeout(30, java.util.concurrent.TimeUnit.SECONDS)
        .build();
  }

  @Override
  public String post(String endpoint, String body) {
    return sendRequest("POST", endpoint, body);
  }

  @Override
  public String put(String endpoint, String body) {
    return sendRequest("PUT", endpoint, body);
  }

  @Override
  public String delete(String endpoint) {
    return sendRequest("DELETE", endpoint, null);
  }

  @Override
  public String get(String endpoint) {
    return sendRequest("GET", endpoint, null);
  }

  @Override
  public String sendRequest(String method, String endpoint, String body) {
    try {
      RequestBody requestBody = RequestBody.create(body != null ? body : "{}", JSON);
      Request.Builder requestBuilder = new Request.Builder()
      .url(baseUrl + endpoint)
      .header(AUTH_HEADER, authBasic);

      switch (method) {
        case "POST": requestBuilder.post(requestBody); break;
        case "PUT": requestBuilder.put(requestBody); break;
        case "DELETE": requestBuilder.delete(); break;
        case "GET": requestBuilder.get(); break;
      }

      try (Response response = client.newCall(requestBuilder.build()).execute()) {
        return response.body().string();
      }
    }catch (IOException e) {
      e.printStackTrace();
    }
    return null;
  }

  @Override
  public String postImagesWithMultipartFormData(String path, List<File> images) {
    try {
      MultipartBody.Builder builder = new MultipartBody.Builder()
          .setType(MultipartBody.FORM);

      for (File image : images) {
        builder.addFormDataPart(
            "images",
            image.getName(),
            RequestBody.create(image, MediaType.parse("image/png")));
      }

      RequestBody requestBody = builder.build();
      Request request = new Request.Builder()
          .url(baseUrl + path)
          .header(AUTH_HEADER, authBasic)
          .post(requestBody)
          .build();

      try (Response response = client.newCall(request).execute()) {
        return response.body().string();
      }
    } catch (IOException e) {
      e.printStackTrace();
    }
    return null;
  }

  @Override
  public String postImageWithMulStringFormData(String path, File image) {

    try {
      RequestBody requestBody = new MultipartBody.Builder()
          .setType(MultipartBody.FORM)
          .addFormDataPart("image", image.getName(), RequestBody.create(image, MediaType.parse("image/png")))
          .build();

      Request request = new Request.Builder()
          .url(baseUrl + path)
          .header(AUTH_HEADER, authBasic)
          .post(requestBody)
          .build();

      try (Response response = client.newCall(request).execute()) {
        return response.body().string();
      }
    } catch (IOException e) {
      e.printStackTrace();
    }
    return null;
  }
}