package io.sendon.base;

import java.time.Instant;

import com.google.gson.JsonObject;

import io.sendon.sender.response.GetUserNumbers.YorN;

public class SendonJsonResponse {
  public int code;
  public String message;
  public JsonObject dataJson;

  public SendonJsonResponse(SendonJsonResponse sendonResponse) {
    this.code = sendonResponse.code;
    this.message = sendonResponse.message;
    this.dataJson = sendonResponse.dataJson;
  }

  public SendonJsonResponse(int code, String message, JsonObject data) {
    this.code = code;
    this.message = message;
    this.dataJson = data;
  }

  protected int getIntValue(JsonObject item, String key) {
    return item.has(key) && !item.get(key).isJsonNull() ? item.get(key).getAsInt() : 0;
  }

  protected String getStringValue(JsonObject item, String key) {
    return item.has(key) && !item.get(key).isJsonNull() ? item.get(key).getAsString() : "";
  }

  protected <T extends Enum<T>> T getEnumValue(JsonObject item, String key, Class<T> enumClass) {
    try {
      return item.has(key) && !item.get(key).isJsonNull() ? Enum.valueOf(enumClass, item.get(key).getAsString()) : null;
    } catch (IllegalArgumentException | NullPointerException e) {
      return null; // Return null if the key is missing or the value cannot be converted
    }
  }

  protected boolean getBooleanValue(JsonObject item, String key, YorN trueValue) {
    return item.has(key) && !item.get(key).isJsonNull() && YorN.valueOf(item.get(key).getAsString()) == trueValue;
  }

  protected String getDateValue(JsonObject item, String key) {
    try {
      if (item.has(key) && !item.get(key).isJsonNull()) {
        Instant instant = Instant.parse(item.get(key).getAsString());
        return java.time.format.DateTimeFormatter.ISO_INSTANT.format(instant);
      } else {
        return null;
      }
    } catch (Exception e) {
      return null;
    }
  }
}
