package io.sendon.base;

import java.io.File;
import java.util.Base64;
import java.util.List;

public abstract class HttpClient {
  protected String authBasic;
  protected String baseUrl;
  protected static final String AUTH_HEADER = "Authorization";
  protected static final String CONTENT_TYPE_HEADER = "Content-Type";
  protected static final String APPLICATION_JSON = "application/json";

  public HttpClient(String baseUrl, String id, String pw) {
    this.baseUrl = baseUrl;
    this.authBasic = "Basic " + encodeBase64(id + ":" + pw);
  }

  protected String encodeBase64(String value) {
    return Base64.getEncoder().encodeToString(value.getBytes());
  }

  public abstract String post(String path, String body);
  public abstract String postImageWithMulStringFormData(String path, File image);
  public abstract String postImagesWithMultipartFormData(String path, List<File> images);
  public abstract String get(String path);
  public abstract String put(String path, String body);
  public abstract String delete(String path);
  public abstract String sendRequest(String method, String path, String body);
}