/*
 * Sendon API
 * Sendon API Generated on 2025-03-20T05:00:21.676Z
 *
 * The version of the OpenAPI document: v2
 * Contact: 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.sendon.api;

import io.sendon.ApiCallback;
import io.sendon.ApiClient;
import io.sendon.ApiException;
import io.sendon.ApiResponse;
import io.sendon.Configuration;
import io.sendon.Pair;
import io.sendon.ProgressRequestBody;
import io.sendon.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.sendon.model.BadRequestCancelResponseDto;
import io.sendon.model.BadRequestSendResponseDto;
import io.sendon.model.BadRequestUploadImagesResponseDto;
import java.math.BigDecimal;
import io.sendon.model.CancelResponseDto;
import java.io.File;
import io.sendon.model.ForbiddenCancelResponseDto;
import io.sendon.model.ForbiddenSendResponseDto;
import io.sendon.model.GetImageUrlsResponseDto;
import io.sendon.model.GetMessageResponseDto;
import io.sendon.model.InternalServerErrorCancelResponseDto;
import io.sendon.model.InternalServerErrorSendResponseDto;
import io.sendon.model.NotFoundCancelResponseDto;
import io.sendon.model.NotFoundGetImageUrlsResponseDto;
import io.sendon.model.NotFoundGetMessageResponseDto;
import io.sendon.model.NotFoundSendResponseDto;
import io.sendon.model.SearchGroupsResponseDto;
import io.sendon.model.SearchRepeatsResponseDto;
import io.sendon.model.SendMessageRequestDto;
import io.sendon.model.SendMessageResponseDto;
import io.sendon.model.SendResponseDto;
import io.sendon.model.UploadImagesResponseDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SdoSms {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SdoSms() {
        this(Configuration.getDefaultApiClient());
    }

    public SdoSms(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for cancelGroup
     * @param groupId 그룹 ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelGroupCall(String groupId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/sms/groups/{groupId}/cancel"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cancelGroupValidateBeforeCall(String groupId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling cancelGroup(Async)");
        }

        return cancelGroupCall(groupId, _callback);

    }

    /**
     * SMS 예약 메시지 그룹 전체 발송 취소
     * 예약 메시지 발송을 취소합니다. 단, 이미 발송된 경우, 예약 발송이 한시간 이내 남은 경우, 취소가 불가능합니다.
     * @param groupId 그룹 ID (required)
     * @return CancelResponseDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public CancelResponseDto cancelGroup(String groupId) throws ApiException {
        ApiResponse<CancelResponseDto> localVarResp = cancelGroupWithHttpInfo(groupId);
        return localVarResp.getData();
    }

    /**
     * SMS 예약 메시지 그룹 전체 발송 취소
     * 예약 메시지 발송을 취소합니다. 단, 이미 발송된 경우, 예약 발송이 한시간 이내 남은 경우, 취소가 불가능합니다.
     * @param groupId 그룹 ID (required)
     * @return ApiResponse&lt;CancelResponseDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CancelResponseDto> cancelGroupWithHttpInfo(String groupId) throws ApiException {
        okhttp3.Call localVarCall = cancelGroupValidateBeforeCall(groupId, null);
        Type localVarReturnType = new TypeToken<CancelResponseDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * SMS 예약 메시지 그룹 전체 발송 취소 (asynchronously)
     * 예약 메시지 발송을 취소합니다. 단, 이미 발송된 경우, 예약 발송이 한시간 이내 남은 경우, 취소가 불가능합니다.
     * @param groupId 그룹 ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelGroupAsync(String groupId, final ApiCallback<CancelResponseDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = cancelGroupValidateBeforeCall(groupId, _callback);
        Type localVarReturnType = new TypeToken<CancelResponseDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for cancelMessage
     * @param groupId 그룹 ID (required)
     * @param messageId 메시지 ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelMessageCall(String groupId, String messageId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/sms/groups/{groupId}/messages/{messageId}/cancel"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()))
            .replace("{" + "messageId" + "}", localVarApiClient.escapeString(messageId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cancelMessageValidateBeforeCall(String groupId, String messageId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling cancelMessage(Async)");
        }

        // verify the required parameter 'messageId' is set
        if (messageId == null) {
            throw new ApiException("Missing the required parameter 'messageId' when calling cancelMessage(Async)");
        }

        return cancelMessageCall(groupId, messageId, _callback);

    }

    /**
     * SMS 예약 메시지 그룹의 특정 메시지만 발송 취소
     * 메시지 발송을 취소합니다. 단, 이미 발송된 경우, 예약 발송이 한시간 이내 남은 경우, 취소가 불가능합니다.
     * @param groupId 그룹 ID (required)
     * @param messageId 메시지 ID (required)
     * @return CancelResponseDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public CancelResponseDto cancelMessage(String groupId, String messageId) throws ApiException {
        ApiResponse<CancelResponseDto> localVarResp = cancelMessageWithHttpInfo(groupId, messageId);
        return localVarResp.getData();
    }

    /**
     * SMS 예약 메시지 그룹의 특정 메시지만 발송 취소
     * 메시지 발송을 취소합니다. 단, 이미 발송된 경우, 예약 발송이 한시간 이내 남은 경우, 취소가 불가능합니다.
     * @param groupId 그룹 ID (required)
     * @param messageId 메시지 ID (required)
     * @return ApiResponse&lt;CancelResponseDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CancelResponseDto> cancelMessageWithHttpInfo(String groupId, String messageId) throws ApiException {
        okhttp3.Call localVarCall = cancelMessageValidateBeforeCall(groupId, messageId, null);
        Type localVarReturnType = new TypeToken<CancelResponseDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * SMS 예약 메시지 그룹의 특정 메시지만 발송 취소 (asynchronously)
     * 메시지 발송을 취소합니다. 단, 이미 발송된 경우, 예약 발송이 한시간 이내 남은 경우, 취소가 불가능합니다.
     * @param groupId 그룹 ID (required)
     * @param messageId 메시지 ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelMessageAsync(String groupId, String messageId, final ApiCallback<CancelResponseDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = cancelMessageValidateBeforeCall(groupId, messageId, _callback);
        Type localVarReturnType = new TypeToken<CancelResponseDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for cancelRepeat
     * @param groupId 그룹 ID (required)
     * @param repeatId 분할 ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelRepeatCall(String groupId, String repeatId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/sms/groups/{groupId}/repeats/{repeatId}/cancel"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()))
            .replace("{" + "repeatId" + "}", localVarApiClient.escapeString(repeatId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cancelRepeatValidateBeforeCall(String groupId, String repeatId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling cancelRepeat(Async)");
        }

        // verify the required parameter 'repeatId' is set
        if (repeatId == null) {
            throw new ApiException("Missing the required parameter 'repeatId' when calling cancelRepeat(Async)");
        }

        return cancelRepeatCall(groupId, repeatId, _callback);

    }

    /**
     * SMS 예약 메시지 그룹의 특정 분할 예약만 취소
     * 메시지 발송을 취소합니다. 단, 이미 발송된 경우, 예약 발송이 한시간 이내 남은 경우, 취소가 불가능합니다.
     * @param groupId 그룹 ID (required)
     * @param repeatId 분할 ID (required)
     * @return CancelResponseDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public CancelResponseDto cancelRepeat(String groupId, String repeatId) throws ApiException {
        ApiResponse<CancelResponseDto> localVarResp = cancelRepeatWithHttpInfo(groupId, repeatId);
        return localVarResp.getData();
    }

    /**
     * SMS 예약 메시지 그룹의 특정 분할 예약만 취소
     * 메시지 발송을 취소합니다. 단, 이미 발송된 경우, 예약 발송이 한시간 이내 남은 경우, 취소가 불가능합니다.
     * @param groupId 그룹 ID (required)
     * @param repeatId 분할 ID (required)
     * @return ApiResponse&lt;CancelResponseDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CancelResponseDto> cancelRepeatWithHttpInfo(String groupId, String repeatId) throws ApiException {
        okhttp3.Call localVarCall = cancelRepeatValidateBeforeCall(groupId, repeatId, null);
        Type localVarReturnType = new TypeToken<CancelResponseDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * SMS 예약 메시지 그룹의 특정 분할 예약만 취소 (asynchronously)
     * 메시지 발송을 취소합니다. 단, 이미 발송된 경우, 예약 발송이 한시간 이내 남은 경우, 취소가 불가능합니다.
     * @param groupId 그룹 ID (required)
     * @param repeatId 분할 ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelRepeatAsync(String groupId, String repeatId, final ApiCallback<CancelResponseDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = cancelRepeatValidateBeforeCall(groupId, repeatId, _callback);
        Type localVarReturnType = new TypeToken<CancelResponseDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createCsvUploadUrl
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createCsvUploadUrlCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/sms/csv/presigned";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createCsvUploadUrlValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return createCsvUploadUrlCall(_callback);

    }

    /**
     * CSV 업로드위한 Presigned URL 발급
     * 
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public void createCsvUploadUrl() throws ApiException {
        createCsvUploadUrlWithHttpInfo();
    }

    /**
     * CSV 업로드위한 Presigned URL 발급
     * 
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> createCsvUploadUrlWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = createCsvUploadUrlValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * CSV 업로드위한 Presigned URL 발급 (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createCsvUploadUrlAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = createCsvUploadUrlValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for find
     * @param groupId 메시지 ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 조회 실패 - 메시지 ID 미존재 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findCall(String groupId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/sms/groups/{groupId}"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call findValidateBeforeCall(String groupId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling find(Async)");
        }

        return findCall(groupId, _callback);

    }

    /**
     * SMS 메시지 그룹 발송 조회
     * 메시지 그룹 발송 상태를 조회합니다.
     * @param groupId 메시지 ID (required)
     * @return GetMessageResponseDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 조회 실패 - 메시지 ID 미존재 </td><td>  -  </td></tr>
     </table>
     */
    public GetMessageResponseDto find(String groupId) throws ApiException {
        ApiResponse<GetMessageResponseDto> localVarResp = findWithHttpInfo(groupId);
        return localVarResp.getData();
    }

    /**
     * SMS 메시지 그룹 발송 조회
     * 메시지 그룹 발송 상태를 조회합니다.
     * @param groupId 메시지 ID (required)
     * @return ApiResponse&lt;GetMessageResponseDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 조회 실패 - 메시지 ID 미존재 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GetMessageResponseDto> findWithHttpInfo(String groupId) throws ApiException {
        okhttp3.Call localVarCall = findValidateBeforeCall(groupId, null);
        Type localVarReturnType = new TypeToken<GetMessageResponseDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * SMS 메시지 그룹 발송 조회 (asynchronously)
     * 메시지 그룹 발송 상태를 조회합니다.
     * @param groupId 메시지 ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 조회 실패 - 메시지 ID 미존재 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findAsync(String groupId, final ApiCallback<GetMessageResponseDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = findValidateBeforeCall(groupId, _callback);
        Type localVarReturnType = new TypeToken<GetMessageResponseDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getImageUrl
     * @param imageId1 이미지 ID (required)
     * @param expireIn 이미지 URL 만료 시간 (초, 기본60초) (optional)
     * @param imageId3 이미지 ID (optional)
     * @param imageId2 이미지 ID (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 성공 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 실패 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getImageUrlCall(Object imageId1, Object expireIn, Object imageId3, Object imageId2, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/sms/image/url";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (expireIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expireIn", expireIn));
        }

        if (imageId3 != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("imageId3", imageId3));
        }

        if (imageId2 != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("imageId2", imageId2));
        }

        if (imageId1 != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("imageId1", imageId1));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getImageUrlValidateBeforeCall(Object imageId1, Object expireIn, Object imageId3, Object imageId2, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'imageId1' is set
        if (imageId1 == null) {
            throw new ApiException("Missing the required parameter 'imageId1' when calling getImageUrl(Async)");
        }

        return getImageUrlCall(imageId1, expireIn, imageId3, imageId2, _callback);

    }

    /**
     * MMS 이미지 조회
     * 업로드된 MMS 이미지를 조회합니다.
     * @param imageId1 이미지 ID (required)
     * @param expireIn 이미지 URL 만료 시간 (초, 기본60초) (optional)
     * @param imageId3 이미지 ID (optional)
     * @param imageId2 이미지 ID (optional)
     * @return GetImageUrlsResponseDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 성공 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 실패 </td><td>  -  </td></tr>
     </table>
     */
    public GetImageUrlsResponseDto getImageUrl(Object imageId1, Object expireIn, Object imageId3, Object imageId2) throws ApiException {
        ApiResponse<GetImageUrlsResponseDto> localVarResp = getImageUrlWithHttpInfo(imageId1, expireIn, imageId3, imageId2);
        return localVarResp.getData();
    }

    /**
     * MMS 이미지 조회
     * 업로드된 MMS 이미지를 조회합니다.
     * @param imageId1 이미지 ID (required)
     * @param expireIn 이미지 URL 만료 시간 (초, 기본60초) (optional)
     * @param imageId3 이미지 ID (optional)
     * @param imageId2 이미지 ID (optional)
     * @return ApiResponse&lt;GetImageUrlsResponseDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 성공 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 실패 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GetImageUrlsResponseDto> getImageUrlWithHttpInfo(Object imageId1, Object expireIn, Object imageId3, Object imageId2) throws ApiException {
        okhttp3.Call localVarCall = getImageUrlValidateBeforeCall(imageId1, expireIn, imageId3, imageId2, null);
        Type localVarReturnType = new TypeToken<GetImageUrlsResponseDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * MMS 이미지 조회 (asynchronously)
     * 업로드된 MMS 이미지를 조회합니다.
     * @param imageId1 이미지 ID (required)
     * @param expireIn 이미지 URL 만료 시간 (초, 기본60초) (optional)
     * @param imageId3 이미지 ID (optional)
     * @param imageId2 이미지 ID (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 성공 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 실패 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getImageUrlAsync(Object imageId1, Object expireIn, Object imageId3, Object imageId2, final ApiCallback<GetImageUrlsResponseDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getImageUrlValidateBeforeCall(imageId1, expireIn, imageId3, imageId2, _callback);
        Type localVarReturnType = new TypeToken<GetImageUrlsResponseDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for searchGroups
     * @param limit 응답받을 데이터 수 (max:100, min:1, default:30) (optional)
     * @param cursor 응답받을 데이터 오프셋 (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call searchGroupsCall(BigDecimal limit, String cursor, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/sms/groups";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (cursor != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cursor", cursor));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call searchGroupsValidateBeforeCall(BigDecimal limit, String cursor, final ApiCallback _callback) throws ApiException {
        return searchGroupsCall(limit, cursor, _callback);

    }

    /**
     * SMS 메시지 그룹 조회
     *   사용자가 발송한 메시지 이력을 조회합니다.
     * @param limit 응답받을 데이터 수 (max:100, min:1, default:30) (optional)
     * @param cursor 응답받을 데이터 오프셋 (optional)
     * @return SearchGroupsResponseDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
     </table>
     */
    public SearchGroupsResponseDto searchGroups(BigDecimal limit, String cursor) throws ApiException {
        ApiResponse<SearchGroupsResponseDto> localVarResp = searchGroupsWithHttpInfo(limit, cursor);
        return localVarResp.getData();
    }

    /**
     * SMS 메시지 그룹 조회
     *   사용자가 발송한 메시지 이력을 조회합니다.
     * @param limit 응답받을 데이터 수 (max:100, min:1, default:30) (optional)
     * @param cursor 응답받을 데이터 오프셋 (optional)
     * @return ApiResponse&lt;SearchGroupsResponseDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SearchGroupsResponseDto> searchGroupsWithHttpInfo(BigDecimal limit, String cursor) throws ApiException {
        okhttp3.Call localVarCall = searchGroupsValidateBeforeCall(limit, cursor, null);
        Type localVarReturnType = new TypeToken<SearchGroupsResponseDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * SMS 메시지 그룹 조회 (asynchronously)
     *   사용자가 발송한 메시지 이력을 조회합니다.
     * @param limit 응답받을 데이터 수 (max:100, min:1, default:30) (optional)
     * @param cursor 응답받을 데이터 오프셋 (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call searchGroupsAsync(BigDecimal limit, String cursor, final ApiCallback<SearchGroupsResponseDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = searchGroupsValidateBeforeCall(limit, cursor, _callback);
        Type localVarReturnType = new TypeToken<SearchGroupsResponseDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for searchRepeats
     * @param groupId 그룹 ID (required)
     * @param limit 응답받을 데이터 수 (max:100, min:1, default:30) (optional)
     * @param cursor 응답받을 데이터 오프셋 (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call searchRepeatsCall(String groupId, BigDecimal limit, String cursor, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/sms/groups/{groupId}/repeats"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (cursor != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cursor", cursor));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call searchRepeatsValidateBeforeCall(String groupId, BigDecimal limit, String cursor, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling searchRepeats(Async)");
        }

        return searchRepeatsCall(groupId, limit, cursor, _callback);

    }

    /**
     * SMS 메시지 그룹내 분할 예약 리스트 조회
     *   사용자가 예약한 분할 예약 리스트 조회합니다.
     * @param groupId 그룹 ID (required)
     * @param limit 응답받을 데이터 수 (max:100, min:1, default:30) (optional)
     * @param cursor 응답받을 데이터 오프셋 (optional)
     * @return SearchRepeatsResponseDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
     </table>
     */
    public SearchRepeatsResponseDto searchRepeats(String groupId, BigDecimal limit, String cursor) throws ApiException {
        ApiResponse<SearchRepeatsResponseDto> localVarResp = searchRepeatsWithHttpInfo(groupId, limit, cursor);
        return localVarResp.getData();
    }

    /**
     * SMS 메시지 그룹내 분할 예약 리스트 조회
     *   사용자가 예약한 분할 예약 리스트 조회합니다.
     * @param groupId 그룹 ID (required)
     * @param limit 응답받을 데이터 수 (max:100, min:1, default:30) (optional)
     * @param cursor 응답받을 데이터 오프셋 (optional)
     * @return ApiResponse&lt;SearchRepeatsResponseDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SearchRepeatsResponseDto> searchRepeatsWithHttpInfo(String groupId, BigDecimal limit, String cursor) throws ApiException {
        okhttp3.Call localVarCall = searchRepeatsValidateBeforeCall(groupId, limit, cursor, null);
        Type localVarReturnType = new TypeToken<SearchRepeatsResponseDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * SMS 메시지 그룹내 분할 예약 리스트 조회 (asynchronously)
     *   사용자가 예약한 분할 예약 리스트 조회합니다.
     * @param groupId 그룹 ID (required)
     * @param limit 응답받을 데이터 수 (max:100, min:1, default:30) (optional)
     * @param cursor 응답받을 데이터 오프셋 (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call searchRepeatsAsync(String groupId, BigDecimal limit, String cursor, final ApiCallback<SearchRepeatsResponseDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = searchRepeatsValidateBeforeCall(groupId, limit, cursor, _callback);
        Type localVarReturnType = new TypeToken<SearchRepeatsResponseDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for send
     * @param sendMessageRequestDto 발송 요청 (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 발송 실패 - 미등록 발신번호 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendCall(SendMessageRequestDto sendMessageRequestDto, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = sendMessageRequestDto;

        // create path and map variables
        String localVarPath = "/v2/messages/sms";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendValidateBeforeCall(SendMessageRequestDto sendMessageRequestDto, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'sendMessageRequestDto' is set
        if (sendMessageRequestDto == null) {
            throw new ApiException("Missing the required parameter 'sendMessageRequestDto' when calling send(Async)");
        }

        return sendCall(sendMessageRequestDto, _callback);

    }

    /**
     * SMS 메시지 발송
     * SMS 메시지를 발송합니다.
     * @param sendMessageRequestDto 발송 요청 (required)
     * @return SendMessageResponseDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 발송 실패 - 미등록 발신번호 </td><td>  -  </td></tr>
     </table>
     */
    public SendMessageResponseDto send(SendMessageRequestDto sendMessageRequestDto) throws ApiException {
        ApiResponse<SendMessageResponseDto> localVarResp = sendWithHttpInfo(sendMessageRequestDto);
        return localVarResp.getData();
    }

    /**
     * SMS 메시지 발송
     * SMS 메시지를 발송합니다.
     * @param sendMessageRequestDto 발송 요청 (required)
     * @return ApiResponse&lt;SendMessageResponseDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 발송 실패 - 미등록 발신번호 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SendMessageResponseDto> sendWithHttpInfo(SendMessageRequestDto sendMessageRequestDto) throws ApiException {
        okhttp3.Call localVarCall = sendValidateBeforeCall(sendMessageRequestDto, null);
        Type localVarReturnType = new TypeToken<SendMessageResponseDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * SMS 메시지 발송 (asynchronously)
     * SMS 메시지를 발송합니다.
     * @param sendMessageRequestDto 발송 요청 (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 발송 실패 - 미등록 발신번호 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendAsync(SendMessageRequestDto sendMessageRequestDto, final ApiCallback<SendMessageResponseDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendValidateBeforeCall(sendMessageRequestDto, _callback);
        Type localVarReturnType = new TypeToken<SendMessageResponseDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendGroup
     * @param groupId 그룹 ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendGroupCall(String groupId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/sms/groups/{groupId}/send"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendGroupValidateBeforeCall(String groupId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling sendGroup(Async)");
        }

        return sendGroupCall(groupId, _callback);

    }

    /**
     * SMS 예약 메시지 그룹내 전체 메시지 즉시 발송
     * 예약 메시지를 즉시 발송합니다. 단, 이미 발송된 경우와 예약 10분 이내 남았을 경우는 즉시 발송이 힘들어요.
     * @param groupId 그룹 ID (required)
     * @return SendResponseDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public SendResponseDto sendGroup(String groupId) throws ApiException {
        ApiResponse<SendResponseDto> localVarResp = sendGroupWithHttpInfo(groupId);
        return localVarResp.getData();
    }

    /**
     * SMS 예약 메시지 그룹내 전체 메시지 즉시 발송
     * 예약 메시지를 즉시 발송합니다. 단, 이미 발송된 경우와 예약 10분 이내 남았을 경우는 즉시 발송이 힘들어요.
     * @param groupId 그룹 ID (required)
     * @return ApiResponse&lt;SendResponseDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SendResponseDto> sendGroupWithHttpInfo(String groupId) throws ApiException {
        okhttp3.Call localVarCall = sendGroupValidateBeforeCall(groupId, null);
        Type localVarReturnType = new TypeToken<SendResponseDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * SMS 예약 메시지 그룹내 전체 메시지 즉시 발송 (asynchronously)
     * 예약 메시지를 즉시 발송합니다. 단, 이미 발송된 경우와 예약 10분 이내 남았을 경우는 즉시 발송이 힘들어요.
     * @param groupId 그룹 ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendGroupAsync(String groupId, final ApiCallback<SendResponseDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendGroupValidateBeforeCall(groupId, _callback);
        Type localVarReturnType = new TypeToken<SendResponseDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendMessage
     * @param groupId 그룹 ID (required)
     * @param messageId 메시지 ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendMessageCall(String groupId, String messageId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/sms/groups/{groupId}/messages/{messageId}/send"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()))
            .replace("{" + "messageId" + "}", localVarApiClient.escapeString(messageId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendMessageValidateBeforeCall(String groupId, String messageId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling sendMessage(Async)");
        }

        // verify the required parameter 'messageId' is set
        if (messageId == null) {
            throw new ApiException("Missing the required parameter 'messageId' when calling sendMessage(Async)");
        }

        return sendMessageCall(groupId, messageId, _callback);

    }

    /**
     * SMS 예약 메시지 그룹의 특정 메시지만 즉시 발송
     * 예약 메시지를 즉시 발송합니다. 단, 이미 발송된 경우와 예약 10분 이내 남았을 경우는 즉시 발송이 힘들어요.
     * @param groupId 그룹 ID (required)
     * @param messageId 메시지 ID (required)
     * @return SendResponseDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public SendResponseDto sendMessage(String groupId, String messageId) throws ApiException {
        ApiResponse<SendResponseDto> localVarResp = sendMessageWithHttpInfo(groupId, messageId);
        return localVarResp.getData();
    }

    /**
     * SMS 예약 메시지 그룹의 특정 메시지만 즉시 발송
     * 예약 메시지를 즉시 발송합니다. 단, 이미 발송된 경우와 예약 10분 이내 남았을 경우는 즉시 발송이 힘들어요.
     * @param groupId 그룹 ID (required)
     * @param messageId 메시지 ID (required)
     * @return ApiResponse&lt;SendResponseDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SendResponseDto> sendMessageWithHttpInfo(String groupId, String messageId) throws ApiException {
        okhttp3.Call localVarCall = sendMessageValidateBeforeCall(groupId, messageId, null);
        Type localVarReturnType = new TypeToken<SendResponseDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * SMS 예약 메시지 그룹의 특정 메시지만 즉시 발송 (asynchronously)
     * 예약 메시지를 즉시 발송합니다. 단, 이미 발송된 경우와 예약 10분 이내 남았을 경우는 즉시 발송이 힘들어요.
     * @param groupId 그룹 ID (required)
     * @param messageId 메시지 ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendMessageAsync(String groupId, String messageId, final ApiCallback<SendResponseDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendMessageValidateBeforeCall(groupId, messageId, _callback);
        Type localVarReturnType = new TypeToken<SendResponseDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendRepeat
     * @param groupId 그룹 ID (required)
     * @param repeatId 분할 ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendRepeatCall(String groupId, String repeatId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/sms/groups/{groupId}/repeats/{repeatId}/send"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()))
            .replace("{" + "repeatId" + "}", localVarApiClient.escapeString(repeatId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendRepeatValidateBeforeCall(String groupId, String repeatId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling sendRepeat(Async)");
        }

        // verify the required parameter 'repeatId' is set
        if (repeatId == null) {
            throw new ApiException("Missing the required parameter 'repeatId' when calling sendRepeat(Async)");
        }

        return sendRepeatCall(groupId, repeatId, _callback);

    }

    /**
     * SMS 예약 메시지 그룹의 특정 분할 예약만 즉시 발송
     * 예약 메시지를 즉시 발송합니다. 단, 이미 발송된 경우와 예약 10분 이내 남았을 경우는 즉시 발송이 힘들어요.
     * @param groupId 그룹 ID (required)
     * @param repeatId 분할 ID (required)
     * @return SendResponseDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public SendResponseDto sendRepeat(String groupId, String repeatId) throws ApiException {
        ApiResponse<SendResponseDto> localVarResp = sendRepeatWithHttpInfo(groupId, repeatId);
        return localVarResp.getData();
    }

    /**
     * SMS 예약 메시지 그룹의 특정 분할 예약만 즉시 발송
     * 예약 메시지를 즉시 발송합니다. 단, 이미 발송된 경우와 예약 10분 이내 남았을 경우는 즉시 발송이 힘들어요.
     * @param groupId 그룹 ID (required)
     * @param repeatId 분할 ID (required)
     * @return ApiResponse&lt;SendResponseDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SendResponseDto> sendRepeatWithHttpInfo(String groupId, String repeatId) throws ApiException {
        okhttp3.Call localVarCall = sendRepeatValidateBeforeCall(groupId, repeatId, null);
        Type localVarReturnType = new TypeToken<SendResponseDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * SMS 예약 메시지 그룹의 특정 분할 예약만 즉시 발송 (asynchronously)
     * 예약 메시지를 즉시 발송합니다. 단, 이미 발송된 경우와 예약 10분 이내 남았을 경우는 즉시 발송이 힘들어요.
     * @param groupId 그룹 ID (required)
     * @param repeatId 분할 ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 정상 응답 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 취소 실패 - 예약 메시지 아닌 경우 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 취소 실패 - 이미 발송된 메시지 또는 발송 임박한 메시지 경우 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 취소 실패 - 발송 메시지 조회 불가 </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> 취소 실패 - 취소 처리 중 에러 발생 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendRepeatAsync(String groupId, String repeatId, final ApiCallback<SendResponseDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendRepeatValidateBeforeCall(groupId, repeatId, _callback);
        Type localVarReturnType = new TypeToken<SendResponseDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for uploadImages
     * @param images 등록할 이미지 파일 (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 성공 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 업로드 실패 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call uploadImagesCall(List<File> images, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/sms/image/upload";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (images != null) {
            localVarFormParams.put("images", images);
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call uploadImagesValidateBeforeCall(List<File> images, final ApiCallback _callback) throws ApiException {
        return uploadImagesCall(images, _callback);

    }

    /**
     * MMS 이미지 업로드
     * MMS 발송에 포함될 이미지를 업로드합니다.
     * @param images 등록할 이미지 파일 (optional)
     * @return UploadImagesResponseDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 성공 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 업로드 실패 </td><td>  -  </td></tr>
     </table>
     */
    public UploadImagesResponseDto uploadImages(List<File> images) throws ApiException {
        ApiResponse<UploadImagesResponseDto> localVarResp = uploadImagesWithHttpInfo(images);
        return localVarResp.getData();
    }

    /**
     * MMS 이미지 업로드
     * MMS 발송에 포함될 이미지를 업로드합니다.
     * @param images 등록할 이미지 파일 (optional)
     * @return ApiResponse&lt;UploadImagesResponseDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 성공 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 업로드 실패 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UploadImagesResponseDto> uploadImagesWithHttpInfo(List<File> images) throws ApiException {
        okhttp3.Call localVarCall = uploadImagesValidateBeforeCall(images, null);
        Type localVarReturnType = new TypeToken<UploadImagesResponseDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * MMS 이미지 업로드 (asynchronously)
     * MMS 발송에 포함될 이미지를 업로드합니다.
     * @param images 등록할 이미지 파일 (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 성공 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 업로드 실패 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call uploadImagesAsync(List<File> images, final ApiCallback<UploadImagesResponseDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = uploadImagesValidateBeforeCall(images, _callback);
        Type localVarReturnType = new TypeToken<UploadImagesResponseDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
