/*
 * Sendon API
 * Sendon API Generated on 2025-03-20T05:00:21.676Z
 *
 * The version of the OpenAPI document: v2
 * Contact: 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.sendon.api;

import io.sendon.ApiCallback;
import io.sendon.ApiClient;
import io.sendon.ApiException;
import io.sendon.ApiResponse;
import io.sendon.Configuration;
import io.sendon.Pair;
import io.sendon.ProgressRequestBody;
import io.sendon.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import java.math.BigDecimal;
import io.sendon.model.GetPaymentHistoriesResponse;
import io.sendon.model.GetPaymentHistoryResponse;
import java.time.OffsetDateTime;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SdoPayment {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SdoPayment() {
        this(Configuration.getDefaultApiClient());
    }

    public SdoPayment(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for getPaymentHistories
     * @param page 페이지 번호 (optional, default to 1)
     * @param limit 페이지당 항목 수 (optional, default to 10)
     * @param startDate 조회 시작일(미지정시 최근 30일) (optional)
     * @param endDate 조회 종료일(미지정시 현재) (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getPaymentHistoriesCall(BigDecimal page, BigDecimal limit, OffsetDateTime startDate, OffsetDateTime endDate, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/payment/payment-histories";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (startDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startDate", startDate));
        }

        if (endDate != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("endDate", endDate));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getPaymentHistoriesValidateBeforeCall(BigDecimal page, BigDecimal limit, OffsetDateTime startDate, OffsetDateTime endDate, final ApiCallback _callback) throws ApiException {
        return getPaymentHistoriesCall(page, limit, startDate, endDate, _callback);

    }

    /**
     * 결제 히스토리 목록 조회
     * 
     * @param page 페이지 번호 (optional, default to 1)
     * @param limit 페이지당 항목 수 (optional, default to 10)
     * @param startDate 조회 시작일(미지정시 최근 30일) (optional)
     * @param endDate 조회 종료일(미지정시 현재) (optional)
     * @return GetPaymentHistoriesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public GetPaymentHistoriesResponse getPaymentHistories(BigDecimal page, BigDecimal limit, OffsetDateTime startDate, OffsetDateTime endDate) throws ApiException {
        ApiResponse<GetPaymentHistoriesResponse> localVarResp = getPaymentHistoriesWithHttpInfo(page, limit, startDate, endDate);
        return localVarResp.getData();
    }

    /**
     * 결제 히스토리 목록 조회
     * 
     * @param page 페이지 번호 (optional, default to 1)
     * @param limit 페이지당 항목 수 (optional, default to 10)
     * @param startDate 조회 시작일(미지정시 최근 30일) (optional)
     * @param endDate 조회 종료일(미지정시 현재) (optional)
     * @return ApiResponse&lt;GetPaymentHistoriesResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GetPaymentHistoriesResponse> getPaymentHistoriesWithHttpInfo(BigDecimal page, BigDecimal limit, OffsetDateTime startDate, OffsetDateTime endDate) throws ApiException {
        okhttp3.Call localVarCall = getPaymentHistoriesValidateBeforeCall(page, limit, startDate, endDate, null);
        Type localVarReturnType = new TypeToken<GetPaymentHistoriesResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 결제 히스토리 목록 조회 (asynchronously)
     * 
     * @param page 페이지 번호 (optional, default to 1)
     * @param limit 페이지당 항목 수 (optional, default to 10)
     * @param startDate 조회 시작일(미지정시 최근 30일) (optional)
     * @param endDate 조회 종료일(미지정시 현재) (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getPaymentHistoriesAsync(BigDecimal page, BigDecimal limit, OffsetDateTime startDate, OffsetDateTime endDate, final ApiCallback<GetPaymentHistoriesResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getPaymentHistoriesValidateBeforeCall(page, limit, startDate, endDate, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentHistoriesResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getPaymentHistory
     * @param historyId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getPaymentHistoryCall(BigDecimal historyId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/payment/payment-histories/{historyId}"
            .replace("{" + "historyId" + "}", localVarApiClient.escapeString(historyId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getPaymentHistoryValidateBeforeCall(BigDecimal historyId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'historyId' is set
        if (historyId == null) {
            throw new ApiException("Missing the required parameter 'historyId' when calling getPaymentHistory(Async)");
        }

        return getPaymentHistoryCall(historyId, _callback);

    }

    /**
     * 결제 히스토리 상세 조회
     * 
     * @param historyId  (required)
     * @return GetPaymentHistoryResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public GetPaymentHistoryResponse getPaymentHistory(BigDecimal historyId) throws ApiException {
        ApiResponse<GetPaymentHistoryResponse> localVarResp = getPaymentHistoryWithHttpInfo(historyId);
        return localVarResp.getData();
    }

    /**
     * 결제 히스토리 상세 조회
     * 
     * @param historyId  (required)
     * @return ApiResponse&lt;GetPaymentHistoryResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GetPaymentHistoryResponse> getPaymentHistoryWithHttpInfo(BigDecimal historyId) throws ApiException {
        okhttp3.Call localVarCall = getPaymentHistoryValidateBeforeCall(historyId, null);
        Type localVarReturnType = new TypeToken<GetPaymentHistoryResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 결제 히스토리 상세 조회 (asynchronously)
     * 
     * @param historyId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getPaymentHistoryAsync(BigDecimal historyId, final ApiCallback<GetPaymentHistoryResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getPaymentHistoryValidateBeforeCall(historyId, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentHistoryResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
