/*
 * Sendon API
 * Sendon API Generated on 2025-03-20T05:00:21.676Z
 *
 * The version of the OpenAPI document: v2
 * Contact: 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.sendon.api;

import io.sendon.ApiCallback;
import io.sendon.ApiClient;
import io.sendon.ApiException;
import io.sendon.ApiResponse;
import io.sendon.Configuration;
import io.sendon.Pair;
import io.sendon.ProgressRequestBody;
import io.sendon.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.sendon.model.BaseResponseSchema;
import java.math.BigDecimal;
import io.sendon.model.CancelGroup200Response;
import io.sendon.model.CreateTemplateRequestSchema;
import io.sendon.model.CreateTemplateResponseSchema;
import java.io.File;
import io.sendon.model.GetGroupInfo200Response;
import io.sendon.model.GetSendProfile200Response;
import io.sendon.model.GetSendProfiles200Response;
import io.sendon.model.GetTemplateResponseSchema;
import io.sendon.model.GetTemplatesResponseSchema;
import io.sendon.model.RegisterChannel400Response;
import io.sendon.model.RegisterChannel401Response;
import io.sendon.model.RegisterChannel403Response;
import io.sendon.model.RegisterChannel406Response;
import io.sendon.model.RegisterChannel409Response;
import io.sendon.model.RegisterChannel412Response;
import io.sendon.model.RegisterChannelRequestSchema;
import io.sendon.model.RegisterChannelResponseSchema;
import io.sendon.model.RequestAuthToken400Response;
import io.sendon.model.RequestAuthToken404Response;
import io.sendon.model.RequestAuthToken412Response;
import io.sendon.model.RequestAuthTokenRequestSchema;
import io.sendon.model.RequestAuthTokenResponseSchema;
import io.sendon.model.SendAlimTalkRequestSchema;
import io.sendon.model.SendFriendTalkRequestSchema;
import io.sendon.model.SendKakaoMessageResponseSchema;
import io.sendon.model.UpdateTemplateDto;
import io.sendon.model.UploadAlimTalkTemplateImageResponseSchema;
import io.sendon.model.UploadFallbackImageResponseSchema;
import io.sendon.model.UploadFriendTalkImageResponseSchema;
import io.sendon.model.UploadFriendTalkWideImageResponseSchema;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SdoKakao {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SdoKakao() {
        this(Configuration.getDefaultApiClient());
    }

    public SdoKakao(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for cancelGroup
     * @param groupId  (required)
     * @param sendonAdminId  (optional)
     * @param sendonUserId  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelGroupCall(String groupId, BigDecimal sendonAdminId, BigDecimal sendonUserId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/groups/{groupId}/cancel"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (sendonAdminId != null) {
            localVarHeaderParams.put("sendon-admin-id", localVarApiClient.parameterToString(sendonAdminId));
        }

        if (sendonUserId != null) {
            localVarHeaderParams.put("sendon-user-id", localVarApiClient.parameterToString(sendonUserId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cancelGroupValidateBeforeCall(String groupId, BigDecimal sendonAdminId, BigDecimal sendonUserId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling cancelGroup(Async)");
        }

        return cancelGroupCall(groupId, sendonAdminId, sendonUserId, _callback);

    }

    /**
     * 그룹 발송 전체 취소
     * 
     * @param groupId  (required)
     * @param sendonAdminId  (optional)
     * @param sendonUserId  (optional)
     * @return CancelGroup200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public CancelGroup200Response cancelGroup(String groupId, BigDecimal sendonAdminId, BigDecimal sendonUserId) throws ApiException {
        ApiResponse<CancelGroup200Response> localVarResp = cancelGroupWithHttpInfo(groupId, sendonAdminId, sendonUserId);
        return localVarResp.getData();
    }

    /**
     * 그룹 발송 전체 취소
     * 
     * @param groupId  (required)
     * @param sendonAdminId  (optional)
     * @param sendonUserId  (optional)
     * @return ApiResponse&lt;CancelGroup200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CancelGroup200Response> cancelGroupWithHttpInfo(String groupId, BigDecimal sendonAdminId, BigDecimal sendonUserId) throws ApiException {
        okhttp3.Call localVarCall = cancelGroupValidateBeforeCall(groupId, sendonAdminId, sendonUserId, null);
        Type localVarReturnType = new TypeToken<CancelGroup200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 그룹 발송 전체 취소 (asynchronously)
     * 
     * @param groupId  (required)
     * @param sendonAdminId  (optional)
     * @param sendonUserId  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelGroupAsync(String groupId, BigDecimal sendonAdminId, BigDecimal sendonUserId, final ApiCallback<CancelGroup200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = cancelGroupValidateBeforeCall(groupId, sendonAdminId, sendonUserId, _callback);
        Type localVarReturnType = new TypeToken<CancelGroup200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for cancelReview
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelReviewCall(String sendProfileId, String templateId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/send-profiles/{sendProfileId}/templates/{templateId}/review-cancel"
            .replace("{" + "sendProfileId" + "}", localVarApiClient.escapeString(sendProfileId.toString()))
            .replace("{" + "templateId" + "}", localVarApiClient.escapeString(templateId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cancelReviewValidateBeforeCall(String sendProfileId, String templateId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'sendProfileId' is set
        if (sendProfileId == null) {
            throw new ApiException("Missing the required parameter 'sendProfileId' when calling cancelReview(Async)");
        }

        // verify the required parameter 'templateId' is set
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling cancelReview(Async)");
        }

        return cancelReviewCall(sendProfileId, templateId, _callback);

    }

    /**
     * 템플릿 검수 요청 취소
     * 
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @return BaseResponseSchema
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public BaseResponseSchema cancelReview(String sendProfileId, String templateId) throws ApiException {
        ApiResponse<BaseResponseSchema> localVarResp = cancelReviewWithHttpInfo(sendProfileId, templateId);
        return localVarResp.getData();
    }

    /**
     * 템플릿 검수 요청 취소
     * 
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @return ApiResponse&lt;BaseResponseSchema&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BaseResponseSchema> cancelReviewWithHttpInfo(String sendProfileId, String templateId) throws ApiException {
        okhttp3.Call localVarCall = cancelReviewValidateBeforeCall(sendProfileId, templateId, null);
        Type localVarReturnType = new TypeToken<BaseResponseSchema>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 템플릿 검수 요청 취소 (asynchronously)
     * 
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelReviewAsync(String sendProfileId, String templateId, final ApiCallback<BaseResponseSchema> _callback) throws ApiException {

        okhttp3.Call localVarCall = cancelReviewValidateBeforeCall(sendProfileId, templateId, _callback);
        Type localVarReturnType = new TypeToken<BaseResponseSchema>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createTemplate
     * @param sendProfileId  (required)
     * @param createTemplateRequestSchema Body (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTemplateCall(String sendProfileId, CreateTemplateRequestSchema createTemplateRequestSchema, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createTemplateRequestSchema;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/send-profiles/{sendProfileId}/templates"
            .replace("{" + "sendProfileId" + "}", localVarApiClient.escapeString(sendProfileId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createTemplateValidateBeforeCall(String sendProfileId, CreateTemplateRequestSchema createTemplateRequestSchema, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'sendProfileId' is set
        if (sendProfileId == null) {
            throw new ApiException("Missing the required parameter 'sendProfileId' when calling createTemplate(Async)");
        }

        return createTemplateCall(sendProfileId, createTemplateRequestSchema, _callback);

    }

    /**
     * 템플릿 생성
     * 
     * @param sendProfileId  (required)
     * @param createTemplateRequestSchema Body (optional)
     * @return CreateTemplateResponseSchema
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public CreateTemplateResponseSchema createTemplate(String sendProfileId, CreateTemplateRequestSchema createTemplateRequestSchema) throws ApiException {
        ApiResponse<CreateTemplateResponseSchema> localVarResp = createTemplateWithHttpInfo(sendProfileId, createTemplateRequestSchema);
        return localVarResp.getData();
    }

    /**
     * 템플릿 생성
     * 
     * @param sendProfileId  (required)
     * @param createTemplateRequestSchema Body (optional)
     * @return ApiResponse&lt;CreateTemplateResponseSchema&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CreateTemplateResponseSchema> createTemplateWithHttpInfo(String sendProfileId, CreateTemplateRequestSchema createTemplateRequestSchema) throws ApiException {
        okhttp3.Call localVarCall = createTemplateValidateBeforeCall(sendProfileId, createTemplateRequestSchema, null);
        Type localVarReturnType = new TypeToken<CreateTemplateResponseSchema>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 템플릿 생성 (asynchronously)
     * 
     * @param sendProfileId  (required)
     * @param createTemplateRequestSchema Body (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTemplateAsync(String sendProfileId, CreateTemplateRequestSchema createTemplateRequestSchema, final ApiCallback<CreateTemplateResponseSchema> _callback) throws ApiException {

        okhttp3.Call localVarCall = createTemplateValidateBeforeCall(sendProfileId, createTemplateRequestSchema, _callback);
        Type localVarReturnType = new TypeToken<CreateTemplateResponseSchema>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteTemplate
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTemplateCall(String sendProfileId, String templateId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/send-profiles/{sendProfileId}/templates/{templateId}/delete"
            .replace("{" + "sendProfileId" + "}", localVarApiClient.escapeString(sendProfileId.toString()))
            .replace("{" + "templateId" + "}", localVarApiClient.escapeString(templateId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteTemplateValidateBeforeCall(String sendProfileId, String templateId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'sendProfileId' is set
        if (sendProfileId == null) {
            throw new ApiException("Missing the required parameter 'sendProfileId' when calling deleteTemplate(Async)");
        }

        // verify the required parameter 'templateId' is set
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling deleteTemplate(Async)");
        }

        return deleteTemplateCall(sendProfileId, templateId, _callback);

    }

    /**
     * 템플릿 삭제
     * 
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @return BaseResponseSchema
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public BaseResponseSchema deleteTemplate(String sendProfileId, String templateId) throws ApiException {
        ApiResponse<BaseResponseSchema> localVarResp = deleteTemplateWithHttpInfo(sendProfileId, templateId);
        return localVarResp.getData();
    }

    /**
     * 템플릿 삭제
     * 
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @return ApiResponse&lt;BaseResponseSchema&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BaseResponseSchema> deleteTemplateWithHttpInfo(String sendProfileId, String templateId) throws ApiException {
        okhttp3.Call localVarCall = deleteTemplateValidateBeforeCall(sendProfileId, templateId, null);
        Type localVarReturnType = new TypeToken<BaseResponseSchema>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 템플릿 삭제 (asynchronously)
     * 
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteTemplateAsync(String sendProfileId, String templateId, final ApiCallback<BaseResponseSchema> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteTemplateValidateBeforeCall(sendProfileId, templateId, _callback);
        Type localVarReturnType = new TypeToken<BaseResponseSchema>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getGroupInfo
     * @param groupId  (required)
     * @param sendonAdminId  (optional)
     * @param sendonUserId  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getGroupInfoCall(String groupId, BigDecimal sendonAdminId, BigDecimal sendonUserId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/groups/{groupId}"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (sendonAdminId != null) {
            localVarHeaderParams.put("sendon-admin-id", localVarApiClient.parameterToString(sendonAdminId));
        }

        if (sendonUserId != null) {
            localVarHeaderParams.put("sendon-user-id", localVarApiClient.parameterToString(sendonUserId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getGroupInfoValidateBeforeCall(String groupId, BigDecimal sendonAdminId, BigDecimal sendonUserId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling getGroupInfo(Async)");
        }

        return getGroupInfoCall(groupId, sendonAdminId, sendonUserId, _callback);

    }

    /**
     * 그룹 상세 조회
     * 
     * @param groupId  (required)
     * @param sendonAdminId  (optional)
     * @param sendonUserId  (optional)
     * @return GetGroupInfo200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public GetGroupInfo200Response getGroupInfo(String groupId, BigDecimal sendonAdminId, BigDecimal sendonUserId) throws ApiException {
        ApiResponse<GetGroupInfo200Response> localVarResp = getGroupInfoWithHttpInfo(groupId, sendonAdminId, sendonUserId);
        return localVarResp.getData();
    }

    /**
     * 그룹 상세 조회
     * 
     * @param groupId  (required)
     * @param sendonAdminId  (optional)
     * @param sendonUserId  (optional)
     * @return ApiResponse&lt;GetGroupInfo200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GetGroupInfo200Response> getGroupInfoWithHttpInfo(String groupId, BigDecimal sendonAdminId, BigDecimal sendonUserId) throws ApiException {
        okhttp3.Call localVarCall = getGroupInfoValidateBeforeCall(groupId, sendonAdminId, sendonUserId, null);
        Type localVarReturnType = new TypeToken<GetGroupInfo200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 그룹 상세 조회 (asynchronously)
     * 
     * @param groupId  (required)
     * @param sendonAdminId  (optional)
     * @param sendonUserId  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getGroupInfoAsync(String groupId, BigDecimal sendonAdminId, BigDecimal sendonUserId, final ApiCallback<GetGroupInfo200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = getGroupInfoValidateBeforeCall(groupId, sendonAdminId, sendonUserId, _callback);
        Type localVarReturnType = new TypeToken<GetGroupInfo200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSendProfile
     * @param sendProfileId 발신 프로필 ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSendProfileCall(String sendProfileId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/send-profiles/{sendProfileId}"
            .replace("{" + "sendProfileId" + "}", localVarApiClient.escapeString(sendProfileId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSendProfileValidateBeforeCall(String sendProfileId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'sendProfileId' is set
        if (sendProfileId == null) {
            throw new ApiException("Missing the required parameter 'sendProfileId' when calling getSendProfile(Async)");
        }

        return getSendProfileCall(sendProfileId, _callback);

    }

    /**
     * 발신 프로필 상세 조회
     * 
     * @param sendProfileId 발신 프로필 ID (required)
     * @return GetSendProfile200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public GetSendProfile200Response getSendProfile(String sendProfileId) throws ApiException {
        ApiResponse<GetSendProfile200Response> localVarResp = getSendProfileWithHttpInfo(sendProfileId);
        return localVarResp.getData();
    }

    /**
     * 발신 프로필 상세 조회
     * 
     * @param sendProfileId 발신 프로필 ID (required)
     * @return ApiResponse&lt;GetSendProfile200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GetSendProfile200Response> getSendProfileWithHttpInfo(String sendProfileId) throws ApiException {
        okhttp3.Call localVarCall = getSendProfileValidateBeforeCall(sendProfileId, null);
        Type localVarReturnType = new TypeToken<GetSendProfile200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 발신 프로필 상세 조회 (asynchronously)
     * 
     * @param sendProfileId 발신 프로필 ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSendProfileAsync(String sendProfileId, final ApiCallback<GetSendProfile200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSendProfileValidateBeforeCall(sendProfileId, _callback);
        Type localVarReturnType = new TypeToken<GetSendProfile200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSendProfiles
     * @param limit 한번에 조회할 개수 (optional)
     * @param cursor 커서 (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSendProfilesCall(BigDecimal limit, String cursor, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/send-profiles";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (cursor != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cursor", cursor));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSendProfilesValidateBeforeCall(BigDecimal limit, String cursor, final ApiCallback _callback) throws ApiException {
        return getSendProfilesCall(limit, cursor, _callback);

    }

    /**
     * 발신 프로필 목록 조회
     * 
     * @param limit 한번에 조회할 개수 (optional)
     * @param cursor 커서 (optional)
     * @return GetSendProfiles200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public GetSendProfiles200Response getSendProfiles(BigDecimal limit, String cursor) throws ApiException {
        ApiResponse<GetSendProfiles200Response> localVarResp = getSendProfilesWithHttpInfo(limit, cursor);
        return localVarResp.getData();
    }

    /**
     * 발신 프로필 목록 조회
     * 
     * @param limit 한번에 조회할 개수 (optional)
     * @param cursor 커서 (optional)
     * @return ApiResponse&lt;GetSendProfiles200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GetSendProfiles200Response> getSendProfilesWithHttpInfo(BigDecimal limit, String cursor) throws ApiException {
        okhttp3.Call localVarCall = getSendProfilesValidateBeforeCall(limit, cursor, null);
        Type localVarReturnType = new TypeToken<GetSendProfiles200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 발신 프로필 목록 조회 (asynchronously)
     * 
     * @param limit 한번에 조회할 개수 (optional)
     * @param cursor 커서 (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSendProfilesAsync(BigDecimal limit, String cursor, final ApiCallback<GetSendProfiles200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSendProfilesValidateBeforeCall(limit, cursor, _callback);
        Type localVarReturnType = new TypeToken<GetSendProfiles200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTemplate
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTemplateCall(String sendProfileId, String templateId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/send-profiles/{sendProfileId}/templates/{templateId}"
            .replace("{" + "sendProfileId" + "}", localVarApiClient.escapeString(sendProfileId.toString()))
            .replace("{" + "templateId" + "}", localVarApiClient.escapeString(templateId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTemplateValidateBeforeCall(String sendProfileId, String templateId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'sendProfileId' is set
        if (sendProfileId == null) {
            throw new ApiException("Missing the required parameter 'sendProfileId' when calling getTemplate(Async)");
        }

        // verify the required parameter 'templateId' is set
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling getTemplate(Async)");
        }

        return getTemplateCall(sendProfileId, templateId, _callback);

    }

    /**
     * 템플릿 상세 조회
     * 
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @return GetTemplateResponseSchema
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public GetTemplateResponseSchema getTemplate(String sendProfileId, String templateId) throws ApiException {
        ApiResponse<GetTemplateResponseSchema> localVarResp = getTemplateWithHttpInfo(sendProfileId, templateId);
        return localVarResp.getData();
    }

    /**
     * 템플릿 상세 조회
     * 
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @return ApiResponse&lt;GetTemplateResponseSchema&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GetTemplateResponseSchema> getTemplateWithHttpInfo(String sendProfileId, String templateId) throws ApiException {
        okhttp3.Call localVarCall = getTemplateValidateBeforeCall(sendProfileId, templateId, null);
        Type localVarReturnType = new TypeToken<GetTemplateResponseSchema>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 템플릿 상세 조회 (asynchronously)
     * 
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTemplateAsync(String sendProfileId, String templateId, final ApiCallback<GetTemplateResponseSchema> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTemplateValidateBeforeCall(sendProfileId, templateId, _callback);
        Type localVarReturnType = new TypeToken<GetTemplateResponseSchema>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTemplates
     * @param sendProfileId  (required)
     * @param keyword 검색 키워드 (optional)
     * @param limit 조회 제한 수 (optional)
     * @param nextCursor 다음 페이지 커서 (optional)
     * @param status 템플릿 상태 필터 (optional)
     * @param sort 정렬 기준 (생성일 또는 최근 사용일) (optional, default to CREATED_AT)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTemplatesCall(String sendProfileId, String keyword, BigDecimal limit, String nextCursor, String status, String sort, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/send-profiles/{sendProfileId}/templates"
            .replace("{" + "sendProfileId" + "}", localVarApiClient.escapeString(sendProfileId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (keyword != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("keyword", keyword));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (nextCursor != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("nextCursor", nextCursor));
        }

        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTemplatesValidateBeforeCall(String sendProfileId, String keyword, BigDecimal limit, String nextCursor, String status, String sort, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'sendProfileId' is set
        if (sendProfileId == null) {
            throw new ApiException("Missing the required parameter 'sendProfileId' when calling getTemplates(Async)");
        }

        return getTemplatesCall(sendProfileId, keyword, limit, nextCursor, status, sort, _callback);

    }

    /**
     * 발신 프로필 템플릿 목록 조회
     * 
     * @param sendProfileId  (required)
     * @param keyword 검색 키워드 (optional)
     * @param limit 조회 제한 수 (optional)
     * @param nextCursor 다음 페이지 커서 (optional)
     * @param status 템플릿 상태 필터 (optional)
     * @param sort 정렬 기준 (생성일 또는 최근 사용일) (optional, default to CREATED_AT)
     * @return GetTemplatesResponseSchema
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public GetTemplatesResponseSchema getTemplates(String sendProfileId, String keyword, BigDecimal limit, String nextCursor, String status, String sort) throws ApiException {
        ApiResponse<GetTemplatesResponseSchema> localVarResp = getTemplatesWithHttpInfo(sendProfileId, keyword, limit, nextCursor, status, sort);
        return localVarResp.getData();
    }

    /**
     * 발신 프로필 템플릿 목록 조회
     * 
     * @param sendProfileId  (required)
     * @param keyword 검색 키워드 (optional)
     * @param limit 조회 제한 수 (optional)
     * @param nextCursor 다음 페이지 커서 (optional)
     * @param status 템플릿 상태 필터 (optional)
     * @param sort 정렬 기준 (생성일 또는 최근 사용일) (optional, default to CREATED_AT)
     * @return ApiResponse&lt;GetTemplatesResponseSchema&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GetTemplatesResponseSchema> getTemplatesWithHttpInfo(String sendProfileId, String keyword, BigDecimal limit, String nextCursor, String status, String sort) throws ApiException {
        okhttp3.Call localVarCall = getTemplatesValidateBeforeCall(sendProfileId, keyword, limit, nextCursor, status, sort, null);
        Type localVarReturnType = new TypeToken<GetTemplatesResponseSchema>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 발신 프로필 템플릿 목록 조회 (asynchronously)
     * 
     * @param sendProfileId  (required)
     * @param keyword 검색 키워드 (optional)
     * @param limit 조회 제한 수 (optional)
     * @param nextCursor 다음 페이지 커서 (optional)
     * @param status 템플릿 상태 필터 (optional)
     * @param sort 정렬 기준 (생성일 또는 최근 사용일) (optional, default to CREATED_AT)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTemplatesAsync(String sendProfileId, String keyword, BigDecimal limit, String nextCursor, String status, String sort, final ApiCallback<GetTemplatesResponseSchema> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTemplatesValidateBeforeCall(sendProfileId, keyword, limit, nextCursor, status, sort, _callback);
        Type localVarReturnType = new TypeToken<GetTemplatesResponseSchema>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for registerChannel
     * @param registerChannelRequestSchema Body (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 400 </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> 401 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 403 </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> 406 </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> 409 </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> 412 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call registerChannelCall(RegisterChannelRequestSchema registerChannelRequestSchema, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = registerChannelRequestSchema;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/send-profiles/register";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call registerChannelValidateBeforeCall(RegisterChannelRequestSchema registerChannelRequestSchema, final ApiCallback _callback) throws ApiException {
        return registerChannelCall(registerChannelRequestSchema, _callback);

    }

    /**
     * 발신 프로필 등록
     * 새로운 프로필을 등록합니다.
     * @param registerChannelRequestSchema Body (optional)
     * @return RegisterChannelResponseSchema
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 400 </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> 401 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 403 </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> 406 </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> 409 </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> 412 </td><td>  -  </td></tr>
     </table>
     */
    public RegisterChannelResponseSchema registerChannel(RegisterChannelRequestSchema registerChannelRequestSchema) throws ApiException {
        ApiResponse<RegisterChannelResponseSchema> localVarResp = registerChannelWithHttpInfo(registerChannelRequestSchema);
        return localVarResp.getData();
    }

    /**
     * 발신 프로필 등록
     * 새로운 프로필을 등록합니다.
     * @param registerChannelRequestSchema Body (optional)
     * @return ApiResponse&lt;RegisterChannelResponseSchema&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 400 </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> 401 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 403 </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> 406 </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> 409 </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> 412 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<RegisterChannelResponseSchema> registerChannelWithHttpInfo(RegisterChannelRequestSchema registerChannelRequestSchema) throws ApiException {
        okhttp3.Call localVarCall = registerChannelValidateBeforeCall(registerChannelRequestSchema, null);
        Type localVarReturnType = new TypeToken<RegisterChannelResponseSchema>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 발신 프로필 등록 (asynchronously)
     * 새로운 프로필을 등록합니다.
     * @param registerChannelRequestSchema Body (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 400 </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> 401 </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> 403 </td><td>  -  </td></tr>
        <tr><td> 406 </td><td> 406 </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> 409 </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> 412 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call registerChannelAsync(RegisterChannelRequestSchema registerChannelRequestSchema, final ApiCallback<RegisterChannelResponseSchema> _callback) throws ApiException {

        okhttp3.Call localVarCall = registerChannelValidateBeforeCall(registerChannelRequestSchema, _callback);
        Type localVarReturnType = new TypeToken<RegisterChannelResponseSchema>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for requestAuthToken
     * @param requestAuthTokenRequestSchema Body (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 400 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 404 </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> 412 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestAuthTokenCall(RequestAuthTokenRequestSchema requestAuthTokenRequestSchema, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = requestAuthTokenRequestSchema;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/send-profiles/request-auth-token";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call requestAuthTokenValidateBeforeCall(RequestAuthTokenRequestSchema requestAuthTokenRequestSchema, final ApiCallback _callback) throws ApiException {
        return requestAuthTokenCall(requestAuthTokenRequestSchema, _callback);

    }

    /**
     * 프로필 인증 SMS 전송
     * 프로필 인증을 위한 SMS를 전송합니다.
     * @param requestAuthTokenRequestSchema Body (optional)
     * @return RequestAuthTokenResponseSchema
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 400 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 404 </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> 412 </td><td>  -  </td></tr>
     </table>
     */
    public RequestAuthTokenResponseSchema requestAuthToken(RequestAuthTokenRequestSchema requestAuthTokenRequestSchema) throws ApiException {
        ApiResponse<RequestAuthTokenResponseSchema> localVarResp = requestAuthTokenWithHttpInfo(requestAuthTokenRequestSchema);
        return localVarResp.getData();
    }

    /**
     * 프로필 인증 SMS 전송
     * 프로필 인증을 위한 SMS를 전송합니다.
     * @param requestAuthTokenRequestSchema Body (optional)
     * @return ApiResponse&lt;RequestAuthTokenResponseSchema&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 400 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 404 </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> 412 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<RequestAuthTokenResponseSchema> requestAuthTokenWithHttpInfo(RequestAuthTokenRequestSchema requestAuthTokenRequestSchema) throws ApiException {
        okhttp3.Call localVarCall = requestAuthTokenValidateBeforeCall(requestAuthTokenRequestSchema, null);
        Type localVarReturnType = new TypeToken<RequestAuthTokenResponseSchema>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 프로필 인증 SMS 전송 (asynchronously)
     * 프로필 인증을 위한 SMS를 전송합니다.
     * @param requestAuthTokenRequestSchema Body (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> 400 </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> 404 </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> 412 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestAuthTokenAsync(RequestAuthTokenRequestSchema requestAuthTokenRequestSchema, final ApiCallback<RequestAuthTokenResponseSchema> _callback) throws ApiException {

        okhttp3.Call localVarCall = requestAuthTokenValidateBeforeCall(requestAuthTokenRequestSchema, _callback);
        Type localVarReturnType = new TypeToken<RequestAuthTokenResponseSchema>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for requestReview
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestReviewCall(String sendProfileId, String templateId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/send-profiles/{sendProfileId}/templates/{templateId}/review"
            .replace("{" + "sendProfileId" + "}", localVarApiClient.escapeString(sendProfileId.toString()))
            .replace("{" + "templateId" + "}", localVarApiClient.escapeString(templateId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call requestReviewValidateBeforeCall(String sendProfileId, String templateId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'sendProfileId' is set
        if (sendProfileId == null) {
            throw new ApiException("Missing the required parameter 'sendProfileId' when calling requestReview(Async)");
        }

        // verify the required parameter 'templateId' is set
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling requestReview(Async)");
        }

        return requestReviewCall(sendProfileId, templateId, _callback);

    }

    /**
     * 템플릿 검수 요청
     * 
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @return BaseResponseSchema
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public BaseResponseSchema requestReview(String sendProfileId, String templateId) throws ApiException {
        ApiResponse<BaseResponseSchema> localVarResp = requestReviewWithHttpInfo(sendProfileId, templateId);
        return localVarResp.getData();
    }

    /**
     * 템플릿 검수 요청
     * 
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @return ApiResponse&lt;BaseResponseSchema&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BaseResponseSchema> requestReviewWithHttpInfo(String sendProfileId, String templateId) throws ApiException {
        okhttp3.Call localVarCall = requestReviewValidateBeforeCall(sendProfileId, templateId, null);
        Type localVarReturnType = new TypeToken<BaseResponseSchema>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 템플릿 검수 요청 (asynchronously)
     * 
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call requestReviewAsync(String sendProfileId, String templateId, final ApiCallback<BaseResponseSchema> _callback) throws ApiException {

        okhttp3.Call localVarCall = requestReviewValidateBeforeCall(sendProfileId, templateId, _callback);
        Type localVarReturnType = new TypeToken<BaseResponseSchema>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendAlimTalk
     * @param sendAlimTalkRequestSchema Body (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendAlimTalkCall(SendAlimTalkRequestSchema sendAlimTalkRequestSchema, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = sendAlimTalkRequestSchema;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/alim-talk";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendAlimTalkValidateBeforeCall(SendAlimTalkRequestSchema sendAlimTalkRequestSchema, final ApiCallback _callback) throws ApiException {
        return sendAlimTalkCall(sendAlimTalkRequestSchema, _callback);

    }

    /**
     * 알림톡 발송 요청
     * 
     * @param sendAlimTalkRequestSchema Body (optional)
     * @return SendKakaoMessageResponseSchema
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public SendKakaoMessageResponseSchema sendAlimTalk(SendAlimTalkRequestSchema sendAlimTalkRequestSchema) throws ApiException {
        ApiResponse<SendKakaoMessageResponseSchema> localVarResp = sendAlimTalkWithHttpInfo(sendAlimTalkRequestSchema);
        return localVarResp.getData();
    }

    /**
     * 알림톡 발송 요청
     * 
     * @param sendAlimTalkRequestSchema Body (optional)
     * @return ApiResponse&lt;SendKakaoMessageResponseSchema&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SendKakaoMessageResponseSchema> sendAlimTalkWithHttpInfo(SendAlimTalkRequestSchema sendAlimTalkRequestSchema) throws ApiException {
        okhttp3.Call localVarCall = sendAlimTalkValidateBeforeCall(sendAlimTalkRequestSchema, null);
        Type localVarReturnType = new TypeToken<SendKakaoMessageResponseSchema>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 알림톡 발송 요청 (asynchronously)
     * 
     * @param sendAlimTalkRequestSchema Body (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendAlimTalkAsync(SendAlimTalkRequestSchema sendAlimTalkRequestSchema, final ApiCallback<SendKakaoMessageResponseSchema> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendAlimTalkValidateBeforeCall(sendAlimTalkRequestSchema, _callback);
        Type localVarReturnType = new TypeToken<SendKakaoMessageResponseSchema>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendFriendTalk
     * @param sendFriendTalkRequestSchema Body (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendFriendTalkCall(SendFriendTalkRequestSchema sendFriendTalkRequestSchema, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = sendFriendTalkRequestSchema;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/friend-talk";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendFriendTalkValidateBeforeCall(SendFriendTalkRequestSchema sendFriendTalkRequestSchema, final ApiCallback _callback) throws ApiException {
        return sendFriendTalkCall(sendFriendTalkRequestSchema, _callback);

    }

    /**
     * 친구톡 발송 요청
     * 
     * @param sendFriendTalkRequestSchema Body (optional)
     * @return SendKakaoMessageResponseSchema
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public SendKakaoMessageResponseSchema sendFriendTalk(SendFriendTalkRequestSchema sendFriendTalkRequestSchema) throws ApiException {
        ApiResponse<SendKakaoMessageResponseSchema> localVarResp = sendFriendTalkWithHttpInfo(sendFriendTalkRequestSchema);
        return localVarResp.getData();
    }

    /**
     * 친구톡 발송 요청
     * 
     * @param sendFriendTalkRequestSchema Body (optional)
     * @return ApiResponse&lt;SendKakaoMessageResponseSchema&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SendKakaoMessageResponseSchema> sendFriendTalkWithHttpInfo(SendFriendTalkRequestSchema sendFriendTalkRequestSchema) throws ApiException {
        okhttp3.Call localVarCall = sendFriendTalkValidateBeforeCall(sendFriendTalkRequestSchema, null);
        Type localVarReturnType = new TypeToken<SendKakaoMessageResponseSchema>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 친구톡 발송 요청 (asynchronously)
     * 
     * @param sendFriendTalkRequestSchema Body (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendFriendTalkAsync(SendFriendTalkRequestSchema sendFriendTalkRequestSchema, final ApiCallback<SendKakaoMessageResponseSchema> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendFriendTalkValidateBeforeCall(sendFriendTalkRequestSchema, _callback);
        Type localVarReturnType = new TypeToken<SendKakaoMessageResponseSchema>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendImmediate
     * @param groupId  (required)
     * @param sendonAdminId  (optional)
     * @param sendonUserId  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendImmediateCall(String groupId, BigDecimal sendonAdminId, BigDecimal sendonUserId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/groups/{groupId}/send"
            .replace("{" + "groupId" + "}", localVarApiClient.escapeString(groupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (sendonAdminId != null) {
            localVarHeaderParams.put("sendon-admin-id", localVarApiClient.parameterToString(sendonAdminId));
        }

        if (sendonUserId != null) {
            localVarHeaderParams.put("sendon-user-id", localVarApiClient.parameterToString(sendonUserId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendImmediateValidateBeforeCall(String groupId, BigDecimal sendonAdminId, BigDecimal sendonUserId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling sendImmediate(Async)");
        }

        return sendImmediateCall(groupId, sendonAdminId, sendonUserId, _callback);

    }

    /**
     * 그룹 발송 전체 즉시 발송
     * 
     * @param groupId  (required)
     * @param sendonAdminId  (optional)
     * @param sendonUserId  (optional)
     * @return CancelGroup200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public CancelGroup200Response sendImmediate(String groupId, BigDecimal sendonAdminId, BigDecimal sendonUserId) throws ApiException {
        ApiResponse<CancelGroup200Response> localVarResp = sendImmediateWithHttpInfo(groupId, sendonAdminId, sendonUserId);
        return localVarResp.getData();
    }

    /**
     * 그룹 발송 전체 즉시 발송
     * 
     * @param groupId  (required)
     * @param sendonAdminId  (optional)
     * @param sendonUserId  (optional)
     * @return ApiResponse&lt;CancelGroup200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CancelGroup200Response> sendImmediateWithHttpInfo(String groupId, BigDecimal sendonAdminId, BigDecimal sendonUserId) throws ApiException {
        okhttp3.Call localVarCall = sendImmediateValidateBeforeCall(groupId, sendonAdminId, sendonUserId, null);
        Type localVarReturnType = new TypeToken<CancelGroup200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 그룹 발송 전체 즉시 발송 (asynchronously)
     * 
     * @param groupId  (required)
     * @param sendonAdminId  (optional)
     * @param sendonUserId  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendImmediateAsync(String groupId, BigDecimal sendonAdminId, BigDecimal sendonUserId, final ApiCallback<CancelGroup200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendImmediateValidateBeforeCall(groupId, sendonAdminId, sendonUserId, _callback);
        Type localVarReturnType = new TypeToken<CancelGroup200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateTemplate
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @param updateTemplateDto Body (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTemplateCall(String sendProfileId, String templateId, UpdateTemplateDto updateTemplateDto, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = updateTemplateDto;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/send-profiles/{sendProfileId}/templates/{templateId}/update"
            .replace("{" + "sendProfileId" + "}", localVarApiClient.escapeString(sendProfileId.toString()))
            .replace("{" + "templateId" + "}", localVarApiClient.escapeString(templateId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateTemplateValidateBeforeCall(String sendProfileId, String templateId, UpdateTemplateDto updateTemplateDto, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'sendProfileId' is set
        if (sendProfileId == null) {
            throw new ApiException("Missing the required parameter 'sendProfileId' when calling updateTemplate(Async)");
        }

        // verify the required parameter 'templateId' is set
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling updateTemplate(Async)");
        }

        return updateTemplateCall(sendProfileId, templateId, updateTemplateDto, _callback);

    }

    /**
     * 템플릿 수정, 검수 완료된 템플릿은 수정 불가능
     * 
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @param updateTemplateDto Body (optional)
     * @return BaseResponseSchema
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public BaseResponseSchema updateTemplate(String sendProfileId, String templateId, UpdateTemplateDto updateTemplateDto) throws ApiException {
        ApiResponse<BaseResponseSchema> localVarResp = updateTemplateWithHttpInfo(sendProfileId, templateId, updateTemplateDto);
        return localVarResp.getData();
    }

    /**
     * 템플릿 수정, 검수 완료된 템플릿은 수정 불가능
     * 
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @param updateTemplateDto Body (optional)
     * @return ApiResponse&lt;BaseResponseSchema&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BaseResponseSchema> updateTemplateWithHttpInfo(String sendProfileId, String templateId, UpdateTemplateDto updateTemplateDto) throws ApiException {
        okhttp3.Call localVarCall = updateTemplateValidateBeforeCall(sendProfileId, templateId, updateTemplateDto, null);
        Type localVarReturnType = new TypeToken<BaseResponseSchema>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 템플릿 수정, 검수 완료된 템플릿은 수정 불가능 (asynchronously)
     * 
     * @param sendProfileId  (required)
     * @param templateId  (required)
     * @param updateTemplateDto Body (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTemplateAsync(String sendProfileId, String templateId, UpdateTemplateDto updateTemplateDto, final ApiCallback<BaseResponseSchema> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateTemplateValidateBeforeCall(sendProfileId, templateId, updateTemplateDto, _callback);
        Type localVarReturnType = new TypeToken<BaseResponseSchema>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for uploadAlimTalkTemplateImage
     * @param image  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call uploadAlimTalkTemplateImageCall(File image, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/alimtalk/image";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (image != null) {
            localVarFormParams.put("image", image);
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call uploadAlimTalkTemplateImageValidateBeforeCall(File image, final ApiCallback _callback) throws ApiException {
        return uploadAlimTalkTemplateImageCall(image, _callback);

    }

    /**
     * 알림톡 템플릿 이미지 파일 업로드
     * 
     * @param image  (optional)
     * @return UploadAlimTalkTemplateImageResponseSchema
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public UploadAlimTalkTemplateImageResponseSchema uploadAlimTalkTemplateImage(File image) throws ApiException {
        ApiResponse<UploadAlimTalkTemplateImageResponseSchema> localVarResp = uploadAlimTalkTemplateImageWithHttpInfo(image);
        return localVarResp.getData();
    }

    /**
     * 알림톡 템플릿 이미지 파일 업로드
     * 
     * @param image  (optional)
     * @return ApiResponse&lt;UploadAlimTalkTemplateImageResponseSchema&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UploadAlimTalkTemplateImageResponseSchema> uploadAlimTalkTemplateImageWithHttpInfo(File image) throws ApiException {
        okhttp3.Call localVarCall = uploadAlimTalkTemplateImageValidateBeforeCall(image, null);
        Type localVarReturnType = new TypeToken<UploadAlimTalkTemplateImageResponseSchema>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 알림톡 템플릿 이미지 파일 업로드 (asynchronously)
     * 
     * @param image  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call uploadAlimTalkTemplateImageAsync(File image, final ApiCallback<UploadAlimTalkTemplateImageResponseSchema> _callback) throws ApiException {

        okhttp3.Call localVarCall = uploadAlimTalkTemplateImageValidateBeforeCall(image, _callback);
        Type localVarReturnType = new TypeToken<UploadAlimTalkTemplateImageResponseSchema>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for uploadFallbackImage
     * @param images 업로드할 파일 목록 (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call uploadFallbackImageCall(List<File> images, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/fallback/image";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (images != null) {
            localVarFormParams.put("images", images);
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call uploadFallbackImageValidateBeforeCall(List<File> images, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'images' is set
        if (images == null) {
            throw new ApiException("Missing the required parameter 'images' when calling uploadFallbackImage(Async)");
        }

        return uploadFallbackImageCall(images, _callback);

    }

    /**
     * 대체문자 이미지 파일 업로드
     * 
     * @param images 업로드할 파일 목록 (required)
     * @return UploadFallbackImageResponseSchema
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public UploadFallbackImageResponseSchema uploadFallbackImage(List<File> images) throws ApiException {
        ApiResponse<UploadFallbackImageResponseSchema> localVarResp = uploadFallbackImageWithHttpInfo(images);
        return localVarResp.getData();
    }

    /**
     * 대체문자 이미지 파일 업로드
     * 
     * @param images 업로드할 파일 목록 (required)
     * @return ApiResponse&lt;UploadFallbackImageResponseSchema&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UploadFallbackImageResponseSchema> uploadFallbackImageWithHttpInfo(List<File> images) throws ApiException {
        okhttp3.Call localVarCall = uploadFallbackImageValidateBeforeCall(images, null);
        Type localVarReturnType = new TypeToken<UploadFallbackImageResponseSchema>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 대체문자 이미지 파일 업로드 (asynchronously)
     * 
     * @param images 업로드할 파일 목록 (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call uploadFallbackImageAsync(List<File> images, final ApiCallback<UploadFallbackImageResponseSchema> _callback) throws ApiException {

        okhttp3.Call localVarCall = uploadFallbackImageValidateBeforeCall(images, _callback);
        Type localVarReturnType = new TypeToken<UploadFallbackImageResponseSchema>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for uploadFriendTalkImage
     * @param image  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call uploadFriendTalkImageCall(File image, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/friendtalk/image";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (image != null) {
            localVarFormParams.put("image", image);
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call uploadFriendTalkImageValidateBeforeCall(File image, final ApiCallback _callback) throws ApiException {
        return uploadFriendTalkImageCall(image, _callback);

    }

    /**
     * 친구톡 이미지 파일 업로드
     * 
     * @param image  (optional)
     * @return UploadFriendTalkImageResponseSchema
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public UploadFriendTalkImageResponseSchema uploadFriendTalkImage(File image) throws ApiException {
        ApiResponse<UploadFriendTalkImageResponseSchema> localVarResp = uploadFriendTalkImageWithHttpInfo(image);
        return localVarResp.getData();
    }

    /**
     * 친구톡 이미지 파일 업로드
     * 
     * @param image  (optional)
     * @return ApiResponse&lt;UploadFriendTalkImageResponseSchema&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UploadFriendTalkImageResponseSchema> uploadFriendTalkImageWithHttpInfo(File image) throws ApiException {
        okhttp3.Call localVarCall = uploadFriendTalkImageValidateBeforeCall(image, null);
        Type localVarReturnType = new TypeToken<UploadFriendTalkImageResponseSchema>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 친구톡 이미지 파일 업로드 (asynchronously)
     * 
     * @param image  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call uploadFriendTalkImageAsync(File image, final ApiCallback<UploadFriendTalkImageResponseSchema> _callback) throws ApiException {

        okhttp3.Call localVarCall = uploadFriendTalkImageValidateBeforeCall(image, _callback);
        Type localVarReturnType = new TypeToken<UploadFriendTalkImageResponseSchema>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for uploadFriendTalkWideImage
     * @param image  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call uploadFriendTalkWideImageCall(File image, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/messages/kakao/friendtalk/image/wide";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (image != null) {
            localVarFormParams.put("image", image);
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call uploadFriendTalkWideImageValidateBeforeCall(File image, final ApiCallback _callback) throws ApiException {
        return uploadFriendTalkWideImageCall(image, _callback);

    }

    /**
     * 와이드 이미지 파일 업로드
     * 
     * @param image  (optional)
     * @return UploadFriendTalkWideImageResponseSchema
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public UploadFriendTalkWideImageResponseSchema uploadFriendTalkWideImage(File image) throws ApiException {
        ApiResponse<UploadFriendTalkWideImageResponseSchema> localVarResp = uploadFriendTalkWideImageWithHttpInfo(image);
        return localVarResp.getData();
    }

    /**
     * 와이드 이미지 파일 업로드
     * 
     * @param image  (optional)
     * @return ApiResponse&lt;UploadFriendTalkWideImageResponseSchema&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UploadFriendTalkWideImageResponseSchema> uploadFriendTalkWideImageWithHttpInfo(File image) throws ApiException {
        okhttp3.Call localVarCall = uploadFriendTalkWideImageValidateBeforeCall(image, null);
        Type localVarReturnType = new TypeToken<UploadFriendTalkWideImageResponseSchema>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 와이드 이미지 파일 업로드 (asynchronously)
     * 
     * @param image  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> 200 </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call uploadFriendTalkWideImageAsync(File image, final ApiCallback<UploadFriendTalkWideImageResponseSchema> _callback) throws ApiException {

        okhttp3.Call localVarCall = uploadFriendTalkWideImageValidateBeforeCall(image, _callback);
        Type localVarReturnType = new TypeToken<UploadFriendTalkWideImageResponseSchema>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
