/*
 * Sendon API
 * Sendon API Generated on 2025-03-20T05:00:21.676Z
 *
 * The version of the OpenAPI document: v2
 * Contact: 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.sendon.api;

import io.sendon.ApiCallback;
import io.sendon.ApiClient;
import io.sendon.ApiException;
import io.sendon.ApiResponse;
import io.sendon.Configuration;
import io.sendon.Pair;
import io.sendon.ProgressRequestBody;
import io.sendon.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import java.math.BigDecimal;
import io.sendon.model.CreateBlocklistRequestDto;
import io.sendon.model.CreateBlocklistResponseDto;
import io.sendon.model.DeleteBlocklistResponseDto;
import io.sendon.model.GetBlocklistResponseDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SdoContacts {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SdoContacts() {
        this(Configuration.getDefaultApiClient());
    }

    public SdoContacts(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for createBlocklist
     * @param createBlocklistRequestDto  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createBlocklistCall(CreateBlocklistRequestDto createBlocklistRequestDto, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createBlocklistRequestDto;

        // create path and map variables
        String localVarPath = "/v2/contacts/blocklist";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createBlocklistValidateBeforeCall(CreateBlocklistRequestDto createBlocklistRequestDto, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'createBlocklistRequestDto' is set
        if (createBlocklistRequestDto == null) {
            throw new ApiException("Missing the required parameter 'createBlocklistRequestDto' when calling createBlocklist(Async)");
        }

        return createBlocklistCall(createBlocklistRequestDto, _callback);

    }

    /**
     * 수신거부 추가
     * 
     * @param createBlocklistRequestDto  (required)
     * @return CreateBlocklistResponseDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public CreateBlocklistResponseDto createBlocklist(CreateBlocklistRequestDto createBlocklistRequestDto) throws ApiException {
        ApiResponse<CreateBlocklistResponseDto> localVarResp = createBlocklistWithHttpInfo(createBlocklistRequestDto);
        return localVarResp.getData();
    }

    /**
     * 수신거부 추가
     * 
     * @param createBlocklistRequestDto  (required)
     * @return ApiResponse&lt;CreateBlocklistResponseDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CreateBlocklistResponseDto> createBlocklistWithHttpInfo(CreateBlocklistRequestDto createBlocklistRequestDto) throws ApiException {
        okhttp3.Call localVarCall = createBlocklistValidateBeforeCall(createBlocklistRequestDto, null);
        Type localVarReturnType = new TypeToken<CreateBlocklistResponseDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 수신거부 추가 (asynchronously)
     * 
     * @param createBlocklistRequestDto  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createBlocklistAsync(CreateBlocklistRequestDto createBlocklistRequestDto, final ApiCallback<CreateBlocklistResponseDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = createBlocklistValidateBeforeCall(createBlocklistRequestDto, _callback);
        Type localVarReturnType = new TypeToken<CreateBlocklistResponseDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteBlocklist
     * @param blocklistId 수신거부 ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteBlocklistCall(BigDecimal blocklistId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/contacts/blocklist/{blocklistId}/delete"
            .replace("{" + "blocklistId" + "}", localVarApiClient.escapeString(blocklistId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteBlocklistValidateBeforeCall(BigDecimal blocklistId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'blocklistId' is set
        if (blocklistId == null) {
            throw new ApiException("Missing the required parameter 'blocklistId' when calling deleteBlocklist(Async)");
        }

        return deleteBlocklistCall(blocklistId, _callback);

    }

    /**
     * 수신거부 삭제
     * 
     * @param blocklistId 수신거부 ID (required)
     * @return DeleteBlocklistResponseDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public DeleteBlocklistResponseDto deleteBlocklist(BigDecimal blocklistId) throws ApiException {
        ApiResponse<DeleteBlocklistResponseDto> localVarResp = deleteBlocklistWithHttpInfo(blocklistId);
        return localVarResp.getData();
    }

    /**
     * 수신거부 삭제
     * 
     * @param blocklistId 수신거부 ID (required)
     * @return ApiResponse&lt;DeleteBlocklistResponseDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<DeleteBlocklistResponseDto> deleteBlocklistWithHttpInfo(BigDecimal blocklistId) throws ApiException {
        okhttp3.Call localVarCall = deleteBlocklistValidateBeforeCall(blocklistId, null);
        Type localVarReturnType = new TypeToken<DeleteBlocklistResponseDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 수신거부 삭제 (asynchronously)
     * 
     * @param blocklistId 수신거부 ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteBlocklistAsync(BigDecimal blocklistId, final ApiCallback<DeleteBlocklistResponseDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteBlocklistValidateBeforeCall(blocklistId, _callback);
        Type localVarReturnType = new TypeToken<DeleteBlocklistResponseDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getBlocklist
     * @param cursor 응답받을 데이터 오프셋 (optional)
     * @param limit 응답받을 데이터 수 (max: 100, min: 1, default: 30) (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBlocklistCall(BigDecimal cursor, BigDecimal limit, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/contacts/blocklist";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (cursor != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cursor", cursor));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getBlocklistValidateBeforeCall(BigDecimal cursor, BigDecimal limit, final ApiCallback _callback) throws ApiException {
        return getBlocklistCall(cursor, limit, _callback);

    }

    /**
     * 수신거부 목록
     * 
     * @param cursor 응답받을 데이터 오프셋 (optional)
     * @param limit 응답받을 데이터 수 (max: 100, min: 1, default: 30) (optional)
     * @return GetBlocklistResponseDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public GetBlocklistResponseDto getBlocklist(BigDecimal cursor, BigDecimal limit) throws ApiException {
        ApiResponse<GetBlocklistResponseDto> localVarResp = getBlocklistWithHttpInfo(cursor, limit);
        return localVarResp.getData();
    }

    /**
     * 수신거부 목록
     * 
     * @param cursor 응답받을 데이터 오프셋 (optional)
     * @param limit 응답받을 데이터 수 (max: 100, min: 1, default: 30) (optional)
     * @return ApiResponse&lt;GetBlocklistResponseDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GetBlocklistResponseDto> getBlocklistWithHttpInfo(BigDecimal cursor, BigDecimal limit) throws ApiException {
        okhttp3.Call localVarCall = getBlocklistValidateBeforeCall(cursor, limit, null);
        Type localVarReturnType = new TypeToken<GetBlocklistResponseDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * 수신거부 목록 (asynchronously)
     * 
     * @param cursor 응답받을 데이터 오프셋 (optional)
     * @param limit 응답받을 데이터 수 (max: 100, min: 1, default: 30) (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getBlocklistAsync(BigDecimal cursor, BigDecimal limit, final ApiCallback<GetBlocklistResponseDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getBlocklistValidateBeforeCall(cursor, limit, _callback);
        Type localVarReturnType = new TypeToken<GetBlocklistResponseDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
