package io.sendon;

import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;

import io.sendon.base.Log;
import io.sendon.contacts.response.AddBlocklist;
import io.sendon.contacts.response.DeleteBlocklist;
import io.sendon.contacts.response.GetBlocklist;
import io.sendon.kakao.request.Profile;
import io.sendon.kakao.request.Template;
import io.sendon.kakao.request.Template.TemplateStatus;
import io.sendon.kakao.response.CancelReviewTemplate;
import io.sendon.kakao.response.CreateTemplate;
import io.sendon.kakao.response.DeleteTemplate;
import io.sendon.kakao.response.GetProfileDetail;
import io.sendon.kakao.response.GetProfiles;
import io.sendon.kakao.response.GetTemplateDetail;
import io.sendon.kakao.response.GetTemplates;
import io.sendon.kakao.response.RegisterProfile;
import io.sendon.kakao.response.RequestAuthToken;
import io.sendon.kakao.response.RequestReviewTemplate;
import io.sendon.kakao.response.SendAlimtalk;
import io.sendon.kakao.response.SendGroup;
import io.sendon.kakao.response.UpdateTemplate;
import io.sendon.kakao.response.UploadAlimtalkImage;
import io.sendon.kakao.response.UploadFallbackImage;
import io.sendon.kakao.response.UploadFriendtalkImage;
import io.sendon.kakao.response.UploadFriendtalkWideImage;
import io.sendon.payment.response.GetPaymentHistories;
import io.sendon.payment.response.GetPaymentHistory;
import io.sendon.point.response.GetCosts;
import io.sendon.point.response.GetPoints;
import io.sendon.sender.response.GetUserNumbers;
import io.sendon.sms.response.CancelGroup;
import io.sendon.sms.response.GenerateCsvPresignedUrl;
import io.sendon.sms.response.GetGroup;
import io.sendon.sms.response.GetImage;
import io.sendon.sms.response.GetRepeats;
import io.sendon.sms.response.SendSms;
import io.sendon.sms.response.UploadImage;

public class SendonTest {
  public static void main(String[] args) {
    // 테스트에 사용할 ID와 API Key
    String id = "teho1";
    String apiKey = "7da7f9f420684b8aa6b2c09a3b10#164";

    // Sendon 인스턴스 생성
    Sendon sendon = Sendon.getInstance(id, apiKey, true);

    // Gson 인스턴스 생성 (Pretty Printing 활성화)
    Gson gson = new GsonBuilder()
        .setPrettyPrinting()
        .disableHtmlEscaping()
        .create();

    /**
    * Contacts
    */
    {
      // AddBlocklist addBlocklist = sendon.contacts.addBlocklist("01012345678");
      // Log.d("AddBlocklist: " + gson.toJson(addBlocklist));

      // GetBlocklist getBlocklist = sendon.contacts.getBlocklist(0, 10);
      // Log.d("GetBlocklist: " + gson.toJson(getBlocklist));

      // DeleteBlocklist deleteBlocklist = sendon.contacts.deleteBlocklist(getBlocklist.data.blocklist.get(0).blockId);
      // Log.d("DeleteBlocklist: " + gson.toJson(deleteBlocklist));
    }
    /**
    * Point
    */
    {
      // GetPoints getPoints = sendon.point.getPoints();
      // Log.d("GetPoints: " + gson.toJson(getPoints));

      // GetCosts getCosts  = sendon.point.getCosts();
      // Log.d("GetCosts: " + gson.toJson(getCosts));
    }

    /**
    * Sender
    */
    {
      // GetUserNumbers getUserNumbers = sendon.sender.getUserNumbers(0, 10);
      // Log.d("GetUserNumbers: " + gson.toJson(getUserNumbers));
    }

    /**
    * Payment
    */
    {
      // GetPaymentHistories getPaymentHistories = sendon.payment.getPaymentHistories(1, 10, "2021-01-01", "2025-12-31");
      // Log.d("GetPaymentHistories: " + gson.toJson(getPaymentHistories));

      // GetPaymentHistory getPaymentHistory = sendon.payment.getPaymentHistory(getPaymentHistories.data.histories.get(0).id);
      // Log.d("GetPaymentHistory: " + gson.toJson(getPaymentHistory));
    }

    /**
    * SMS
    */
    {
      // SendSms sendSms = sendon.sms.sendSms("01053601894", Arrays.asList("01053601894"), "Hello, World!", true, null);
      // Log.d("SendSms: " + gson.toJson(sendSms));

      // GetGroup getGroup = sendon.sms.getGroup("bc13658e-8031-41c8-a9dc-6858ebf80055");
      // Log.d("GetGroup: " + gson.toJson(getGroup));

      // GetRepeats getRepeats = sendon.sms.getRepeats("8199b45c-9722-4365-8d5c-8123bb9d437f", 10, "");
      // Log.d("GetRepeats: " + gson.toJson(getRepeats));

      // CancelGroup cancelGroup = sendon.sms.cancelGroup("bc13658e-8031-41c8-a9dc-6858ebf80055");
      // Log.d("CancelGroup: " + gson.toJson(cancelGroup));

      // io.sendon.sms.response.SendGroup sendGroup = sendon.sms.sendGroup("bc13658e-8031-41c8-a9dc-6858ebf80055");
      // Log.d("SendGroup: " + gson.toJson(sendGroup));

      // GenerateCsvPresignedUrl generateCsvPresignedUrl = sendon.sms.generateCsvPresignedUrl();
      // Log.d("GenerateCsvPresignedUrl: " + gson.toJson(generateCsvPresignedUrl));

      // List<File> images = Arrays.asList(
      //   new File("/Users/tehokang/workspaces/aligo/sendon/packages/v2/sdk/wrapper/java/dev/img/test1.png"),
      //   new File("/Users/tehokang/workspaces/aligo/sendon/packages/v2/sdk/wrapper/java/dev/img/test2.jpg")
      // );
      // UploadImage uploadImage = sendon.sms.uploadImages(images);
      // Log.d("UploadImage: " + gson.toJson(uploadImage));

      // List<String> imageIds = Arrays.asList(uploadImage.data.images.get(0).id, uploadImage.data.images.get(1).id);
      // GetImage getImage = sendon.sms.getImages(imageIds);
      // Log.d("GetImage: " + gson.toJson(getImage));
    }

    /**
     * Kakao
     */
    {
      // RequestAuthToken requestAuthToken = sendon.kakao.requestAuthToken("alipeople", "01053601894");
      // Log.d("RequestAuthToken: " + gson.toJson(requestAuthToken));

      // RegisterProfile registerProfile = sendon.kakao.registerProfile(
      //   new Profile().setToken("161609").setChannelId("161609").setPhoneNumber("01053601894")
      // );
      // Log.d("RegisterProfile: " + gson.toJson(registerProfile));

      // GetProfiles getProfiles = sendon.kakao.getProfiles(10, null);
      // Log.d("GetProfiles: " + gson.toJson(getProfiles));

      // GetProfileDetail getProfileDetail = sendon.kakao.getProfileDetail("alipeople");
      // Log.d("GetProfileDetail: " + gson.toJson(getProfileDetail));

      // CreateTemplate createTemplate = sendon.kakao.createTemplate(
      //     "alipeople",
      //     new Template()
      //       .setTemplateName("test1")
      //       .setTemplateContent("Hello, World!")
      // );
      // Log.d("CreateTemplate: " + gson.toJson(createTemplate));

      // GetTemplates  getTemplates = sendon.kakao.getTemplates("alipeople", null, 1, null, TemplateStatus.APPROVED, null);
      // Log.d("GetTemplates: " + gson.toJson(getTemplates));

      // UpdateTemplate updateTemplate = sendon.kakao.updateTemplate(
      //     "alipeople",
      //     "2un0sAWrT58LZizsqY6gcTr6JYC",
      //     new Template()
      //       .setTemplateName("test2")
      //       .setTemplateContent("Hello, World!")
      // );
      // Log.d("UpdateTemplate: " + gson.toJson(updateTemplate));

      // RequestReviewTemplate requestReviewTemplate = sendon.kakao.requestReviewTemplate("alipeople", "2un0sAWrT58LZizsqY6gcTr6JYC");
      // Log.d("RequestReviewTemplate: " + gson.toJson(requestReviewTemplate));

      // CancelReviewTemplate cancelReviewTemplate = sendon.kakao.cancelReviewTemplate("alipeople", "2un0sAWrT58LZizsqY6gcTr6JYC");
      // Log.d("CancelReviewTemplate: " + gson.toJson(cancelReviewTemplate));

      // GetTemplateDetail getTemplateDetail = sendon.kakao.getTemplateDetail("alipeople", "2un0sAWrT58LZizsqY6gcTr6JYC");
      // Log.d("GetTemplateDetail: " + gson.toJson(getTemplateDetail));

      // DeleteTemplate deleteTemplate = sendon.kakao.deleteTemplate("alipeople", "2un0sAWrT58LZizsqY6gcTr6JYC");
      // Log.d("DeleteTemplate: " + gson.toJson(deleteTemplate));

      // File file = new File("/Users/tehokang/workspaces/aligo/sendon/packages/v2/sdk/wrapper/java/dev/img/test1.png");
      // UploadAlimtalkImage uploadAlimtalkImage = sendon.kakao.uploadAlimtalkImage(file);
      // Log.d("UploadAlimtalkImage: " + gson.toJson(uploadAlimtalkImage));

      // UploadFriendtalkImage uploadFriendtalkImage = sendon.kakao.uploadFriendtalkImage(file);
      // Log.d("UploadFriendtalkImage: " + gson.toJson(uploadFriendtalkImage));

      // UploadFriendtalkWideImage uploadFriendtalkWideImage = sendon.kakao.uploadFriendtalkWideImage(file);
      // Log.d("UploadFriendtalkWideImage: " + gson.toJson(uploadFriendtalkWideImage));

      // UploadFallbackImage uploadFallbackImage = sendon.kakao.uploadFallbackImage(Arrays.asList(file));
      // Log.d("UploadFallbackImage: " + gson.toJson(uploadFallbackImage));

      // io.sendon.kakao.request.SendAlimtalk alimtalk = new io.sendon.kakao.request.SendAlimtalk();
      // SendAlimtalk sendAlimtalkResult = sendon.kakao.sendAlimtalk(alimtalk
      //     .setProfileId("alipeople")
      //     .setTemplateId("2uWevezpVnvPM5rf15EaZedqmhu")
      //     .setTo(Arrays.asList("01053601894"))
      // );
      // Log.d("SendAlimtalk: " + gson.toJson(sendAlimtalkResult));

      // io.sendon.kakao.response.GetGroup getGroup = sendon.kakao.getGroup("0195cb3a-3981-75e4-bf95-4948f4637a73");
      // Log.d("GetGroup: " + gson.toJson(getGroup));

      // io.sendon.kakao.response.CancelGroup cancelGroup = sendon.kakao.cancelGroup("0195cb3a-3981-75e4-bf95-4948f4637a73");
      // Log.d("CancelGroup: " + gson.toJson(cancelGroup));

      // SendGroup sendGroup = sendon.kakao.sendGroup("0195cb3a-3981-75e4-bf95-4948f4637a73");
      // Log.d("SendGroup: " + gson.toJson(sendGroup));

    }
  }
}