package io.sendon;

import io.sendon.base.Log;
import io.sendon.contacts.*;
import io.sendon.kakao.SendonKakao;
import io.sendon.point.SendonPoint;
import io.sendon.sender.SendonSender;
import io.sendon.sms.SendonSms;
import io.sendon.payment.SendonPayment;

public class Sendon {

  private static Sendon instance = null;
  public final SendonContacts contacts;
  public final SendonPoint point;
  public final SendonSender sender;
  public final SendonPayment payment;
  public final SendonSms sms;
  public final SendonKakao kakao;

  private Sendon(String id, String apiKey, boolean debug) {

    this.contacts = new SendonContacts(id, apiKey);
    this.point = new SendonPoint(id, apiKey);
    this.sender = new SendonSender(id, apiKey);
    this.payment = new SendonPayment(id, apiKey);
    this.sms = new SendonSms(id, apiKey);
    this.kakao = new SendonKakao(id, apiKey);

    Log.debug = debug;
    Log.warn = debug;
    Log.error = debug;
    Log.info = debug;
  }

  public static Sendon getInstance(String id, String apiKey) {
    // debug 기본값을 false로 설정
    return getInstance(id, apiKey, false);
  }

  public static Sendon getInstance(String id, String apiKey, boolean debug) {
    if (instance == null) {
      instance = new Sendon(id, apiKey, debug);
    }
    return instance;
  }

  public SendonContacts getContacts() {
    return contacts;
  }

  public SendonPoint getPoint() {
    return point;
  }

  public SendonSender getSender() {
    return sender;
  }

  public SendonPayment getPayment() {
    return payment;
  }

  public SendonSms getSms() {
    return sms;
  }

  public SendonKakao getKakao() {
    return kakao;
  }
}
