/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.core.Exceptions;

public final class Address {
    private static final Pattern ADDRESS_FORMAT = Pattern.compile("(?<host>^.*):(?<port>\\d+$)");
    private String host;
    private int port;

    Address() {
    }

    private Address(String host, int port) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("host must be present");
        }
        if (port < 0) {
            throw new IllegalArgumentException("port must be eq or greater than 0");
        }
        this.host = Address.convertIfLocalhost(host);
        this.port = port;
    }

    public static Address from(String hostandport) {
        int port;
        if (hostandport == null || hostandport.isEmpty()) {
            throw new IllegalArgumentException("host-and-port string must be present");
        }
        Matcher matcher = ADDRESS_FORMAT.matcher(hostandport);
        if (!matcher.find()) {
            throw new IllegalArgumentException("can't parse host-and-port string from: " + hostandport);
        }
        String host = matcher.group(1);
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("can't parse host from: " + hostandport);
        }
        try {
            port = Integer.parseInt(matcher.group(2));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("can't parse port from: " + hostandport, ex);
        }
        return new Address(host, port);
    }

    public static Address create(String host, int port) {
        return new Address(host, port);
    }

    public static InetAddress getLocalIpAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static String convertIfLocalhost(String host) {
        String result;
        switch (host) {
            case "localhost": 
            case "127.0.0.1": 
            case "127.0.1.1": {
                result = Address.getLocalIpAddress().getHostAddress();
                break;
            }
            default: {
                result = host;
            }
        }
        return result;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Address that = (Address)other;
        return Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return this.host + ":" + this.port;
    }
}

