/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import io.scalecube.transport.JacksonMessageCodec;
import io.scalecube.transport.MessageCodec;

public final class TransportConfig {
    public static final int DEFAULT_PORT = 0;
    public static final int DEFAULT_CONNECT_TIMEOUT = 3000;
    public static final boolean DEFAULT_USE_NETWORK_EMULATOR = false;
    public static final MessageCodec DEFAULT_MESSAGE_CODEC = new JacksonMessageCodec();
    private final int port;
    private final int connectTimeout;
    private final boolean useNetworkEmulator;
    private final MessageCodec messageCodec;

    private TransportConfig(Builder builder) {
        this.port = builder.port;
        this.connectTimeout = builder.connectTimeout;
        this.useNetworkEmulator = builder.useNetworkEmulator;
        this.messageCodec = builder.messageCodec;
    }

    public static TransportConfig defaultConfig() {
        return TransportConfig.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getPort() {
        return this.port;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isUseNetworkEmulator() {
        return this.useNetworkEmulator;
    }

    public MessageCodec getMessageCodec() {
        return this.messageCodec;
    }

    public String toString() {
        return "TransportConfig{port=" + this.port + ", connectTimeout=" + this.connectTimeout + ", useNetworkEmulator=" + this.useNetworkEmulator + ", messageCodec=" + this.messageCodec + '}';
    }

    public static final class Builder {
        private int port = 0;
        private boolean useNetworkEmulator = false;
        private int connectTimeout = 3000;
        private MessageCodec messageCodec = DEFAULT_MESSAGE_CODEC;

        private Builder() {
        }

        public Builder fillFrom(TransportConfig config) {
            this.port = config.port;
            this.connectTimeout = config.connectTimeout;
            this.useNetworkEmulator = config.useNetworkEmulator;
            this.messageCodec = config.messageCodec;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder useNetworkEmulator(boolean useNetworkEmulator) {
            this.useNetworkEmulator = useNetworkEmulator;
            return this;
        }

        public Builder messageCodec(MessageCodec messageCodec) {
            this.messageCodec = messageCodec;
            return this;
        }

        public TransportConfig build() {
            return new TransportConfig(this);
        }
    }
}

