/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

public final class TransportConfig {
    public static final int DEFAULT_PORT = 0;
    public static final int DEFAULT_CONNECT_TIMEOUT = 3000;
    public static final boolean DEFAULT_USE_NETWORK_EMULATOR = false;
    public static final boolean DEFAULT_ENABLE_EPOLL = true;
    public static final int DEFAULT_BOSS_THREADS = 2;
    public static final int DEFAULT_WORKER_THREADS = 0;
    private final int port;
    private final int connectTimeout;
    private final boolean useNetworkEmulator;
    private final boolean enableEpoll;
    private final int bossThreads;
    private final int workerThreads;

    private TransportConfig(Builder builder) {
        this.port = builder.port;
        this.connectTimeout = builder.connectTimeout;
        this.useNetworkEmulator = builder.useNetworkEmulator;
        this.enableEpoll = builder.enableEpoll;
        this.bossThreads = builder.bossThreads;
        this.workerThreads = builder.workerThreads;
    }

    public static TransportConfig defaultConfig() {
        return TransportConfig.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getPort() {
        return this.port;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isUseNetworkEmulator() {
        return this.useNetworkEmulator;
    }

    public boolean isEnableEpoll() {
        return this.enableEpoll;
    }

    public int getBossThreads() {
        return this.bossThreads;
    }

    public int getWorkerThreads() {
        return this.workerThreads;
    }

    public String toString() {
        return "TransportConfig{port=" + this.port + ", connectTimeout=" + this.connectTimeout + ", useNetworkEmulator=" + this.useNetworkEmulator + ", enableEpoll=" + this.enableEpoll + ", bossThreads=" + this.bossThreads + ", workerThreads=" + this.workerThreads + '}';
    }

    public static final class Builder {
        private int port = 0;
        private boolean useNetworkEmulator = false;
        private int connectTimeout = 3000;
        private boolean enableEpoll = true;
        private int bossThreads = 2;
        private int workerThreads = 0;

        private Builder() {
        }

        public Builder fillFrom(TransportConfig config) {
            this.port = config.port;
            this.connectTimeout = config.connectTimeout;
            this.useNetworkEmulator = config.useNetworkEmulator;
            this.enableEpoll = config.enableEpoll;
            this.bossThreads = config.bossThreads;
            this.workerThreads = config.workerThreads;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder useNetworkEmulator(boolean useNetworkEmulator) {
            this.useNetworkEmulator = useNetworkEmulator;
            return this;
        }

        public Builder enableEpoll(boolean enableEpoll) {
            this.enableEpoll = enableEpoll;
            return this;
        }

        public Builder bossThreads(int bossThreads) {
            this.bossThreads = bossThreads;
            return this;
        }

        public Builder workerThreads(int workerThreads) {
            this.workerThreads = workerThreads;
            return this;
        }

        public TransportConfig build() {
            return new TransportConfig(this);
        }
    }
}

