/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import io.scalecube.transport.Address;
import io.scalecube.transport.Message;
import io.scalecube.transport.NetworkEmulator;
import io.scalecube.transport.TransportConfig;
import io.scalecube.transport.TransportImpl;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface Transport {
    public static Transport bindAwait() {
        return Transport.bindAwait(TransportConfig.defaultConfig());
    }

    public static Transport bindAwait(boolean useNetworkEmulator) {
        return Transport.bindAwait(TransportConfig.builder().useNetworkEmulator(useNetworkEmulator).build());
    }

    public static Transport bindAwait(TransportConfig config) {
        try {
            return (Transport)Transport.bind(config).block();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)(e.getCause() != null ? e.getCause() : e));
        }
    }

    public static Mono<Transport> bind() {
        return Transport.bind(TransportConfig.defaultConfig());
    }

    public static Mono<Transport> bind(TransportConfig config) {
        return new TransportImpl(config).bind0();
    }

    public Address address();

    public Mono<Void> stop();

    public boolean isStopped();

    public Mono<Void> send(Address var1, Message var2);

    public Flux<Message> listen();

    public NetworkEmulator networkEmulator();
}

