/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import io.netty.util.Recycler;
import io.protostuff.LinkedBuffer;
import java.util.Objects;

final class RecyclableLinkedBuffer
implements AutoCloseable {
    public static final int DEFAULT_BUFFER_SIZE = 512;
    public static final int DEFAULT_MAX_CAPACITY = 256;
    private LinkedBuffer buffer;
    private Recycler.Handle handle;
    private final Recycler<RecyclableLinkedBuffer> recycler;

    public RecyclableLinkedBuffer() {
        this(512, 256);
    }

    public RecyclableLinkedBuffer(final int bufferSize, int maxCapacity) {
        this.recycler = new Recycler<RecyclableLinkedBuffer>(maxCapacity){

            protected RecyclableLinkedBuffer newObject(Recycler.Handle handle) {
                RecyclableLinkedBuffer wrapper = new RecyclableLinkedBuffer();
                wrapper.buffer = LinkedBuffer.allocate((int)bufferSize);
                wrapper.handle = handle;
                return wrapper;
            }
        };
    }

    public LinkedBuffer buffer() {
        return Objects.requireNonNull(this.buffer, "Call LinkedBufferWrapper.get() first");
    }

    public RecyclableLinkedBuffer get() {
        return (RecyclableLinkedBuffer)this.recycler.get();
    }

    public void release() {
        Objects.requireNonNull(this.buffer, "Call LinkedBufferWrapper.get() first");
        this.buffer.clear();
        this.recycler.recycle((Object)this, this.handle);
    }

    @Override
    public void close() {
        this.release();
    }
}

