/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.core.Exceptions;

public final class Address {
    private static final Pattern ADDRESS_FORMAT = Pattern.compile("(?<host>^.*):(?<port>\\d+$)");
    private final String host;
    private final int port;

    private Address(String host, int port) {
        Address.requireNonEmpty(host);
        this.host = host;
        this.port = port;
    }

    public static Address from(String hostAndPort) {
        Address.requireNonEmpty(hostAndPort);
        Matcher matcher = ADDRESS_FORMAT.matcher(hostAndPort);
        if (!matcher.find()) {
            throw new IllegalArgumentException();
        }
        String host = matcher.group(1);
        Address.requireNonEmpty(host);
        String host1 = "localhost".equals(host) || "127.0.0.1".equals(host) ? Address.getLocalIpAddress().getHostAddress() : host;
        int port = Integer.parseInt(matcher.group(2));
        return new Address(host1, port);
    }

    public static Address create(String host, int port) {
        return new Address(host, port);
    }

    public static InetAddress getLocalIpAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Address that = (Address)other;
        return Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    private static void requireNonEmpty(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
    }
}

