/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ServerChannel;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.util.concurrent.GenericFutureListener;
import io.scalecube.transport.Address;
import io.scalecube.transport.Addressing;
import io.scalecube.transport.BootstrapFactory;
import io.scalecube.transport.ExceptionHandler;
import io.scalecube.transport.Message;
import io.scalecube.transport.MessageDeserializerHandler;
import io.scalecube.transport.MessageHandler;
import io.scalecube.transport.MessageSerializerHandler;
import io.scalecube.transport.NetworkEmulator;
import io.scalecube.transport.NetworkEmulatorHandler;
import io.scalecube.transport.Transport;
import io.scalecube.transport.TransportConfig;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.FluxSink;

final class TransportImpl
implements Transport {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportImpl.class);
    private static final CompletableFuture<Void> COMPLETED_PROMISE = CompletableFuture.completedFuture(null);
    private final TransportConfig config;
    private final FluxProcessor<Message, Message> incomingMessagesSubject = DirectProcessor.create().serialize();
    private final FluxSink<Message> messageSink = this.incomingMessagesSubject.sink();
    private final Map<Address, ChannelFuture> outgoingChannels = new ConcurrentHashMap<Address, ChannelFuture>();
    private final BootstrapFactory bootstrapFactory;
    private final IncomingChannelInitializer incomingChannelInitializer = new IncomingChannelInitializer();
    private final ExceptionHandler exceptionHandler = new ExceptionHandler();
    private final MessageToByteEncoder<Message> serializerHandler;
    private final MessageToMessageDecoder<ByteBuf> deserializerHandler;
    private final MessageHandler messageHandler;
    private NetworkEmulator networkEmulator;
    private NetworkEmulatorHandler networkEmulatorHandler;
    private Address address;
    private ServerChannel serverChannel;
    private volatile boolean stopped = false;

    public TransportImpl(TransportConfig config) {
        this.config = Objects.requireNonNull(config);
        this.serializerHandler = new MessageSerializerHandler();
        this.deserializerHandler = new MessageDeserializerHandler();
        this.messageHandler = new MessageHandler(this.messageSink);
        this.bootstrapFactory = new BootstrapFactory(config);
    }

    public CompletableFuture<Transport> bind0() {
        ServerBootstrap server = this.bootstrapFactory.serverBootstrap().childHandler((ChannelHandler)this.incomingChannelInitializer);
        InetAddress listenAddress = Addressing.getLocalIpAddress(this.config.getListenAddress(), this.config.getListenInterface(), this.config.isPreferIPv6());
        int bindPort = this.config.getPort();
        return this.bind0(server, listenAddress, bindPort);
    }

    private CompletableFuture<Transport> bind0(ServerBootstrap server, InetAddress listenAddress, int bindPort) {
        CompletableFuture<Transport> result = new CompletableFuture<Transport>();
        ChannelFuture bindFuture = server.bind(listenAddress, bindPort);
        bindFuture.addListener(channelFuture -> {
            if (channelFuture.isSuccess()) {
                this.serverChannel = (ServerChannel)((ChannelFuture)channelFuture).channel();
                this.address = TransportImpl.toAddress(this.serverChannel.localAddress());
                this.networkEmulator = new NetworkEmulator(this.address, this.config.isUseNetworkEmulator());
                this.networkEmulatorHandler = this.config.isUseNetworkEmulator() ? new NetworkEmulatorHandler(this.networkEmulator) : null;
                LOGGER.info("Bound to: {}", (Object)this.address);
                result.complete(this);
            } else {
                Throwable cause = channelFuture.cause();
                LOGGER.error("Failed to bind to: {}, cause: {}", (Object)listenAddress, (Object)cause);
                result.completeExceptionally(cause);
            }
        });
        return result;
    }

    @Override
    public Address address() {
        return this.address;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public NetworkEmulator networkEmulator() {
        return this.networkEmulator;
    }

    @Override
    public final void stop() {
        this.stop(COMPLETED_PROMISE);
    }

    @Override
    public final void stop(CompletableFuture<Void> promise) {
        if (this.stopped) {
            throw new IllegalStateException("Transport is stopped");
        }
        Objects.requireNonNull(promise);
        this.stopped = true;
        try {
            this.messageSink.complete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Address address : this.outgoingChannels.keySet()) {
            ChannelFuture channelFuture = this.outgoingChannels.get(address);
            if (channelFuture == null) continue;
            if (channelFuture.isSuccess()) {
                channelFuture.channel().close();
                continue;
            }
            channelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        this.outgoingChannels.clear();
        if (this.serverChannel != null) {
            this.composeFutures(this.serverChannel.close(), promise);
        }
        this.bootstrapFactory.shutdown();
    }

    @Override
    public final Flux<Message> listen() {
        if (this.stopped) {
            throw new IllegalStateException("Transport is stopped");
        }
        return this.incomingMessagesSubject.onBackpressureBuffer();
    }

    @Override
    public void send(Address address, Message message) {
        this.send(address, message, COMPLETED_PROMISE);
    }

    @Override
    public void send(Address address, Message message, CompletableFuture<Void> promise) {
        if (this.stopped) {
            throw new IllegalStateException("Transport is stopped");
        }
        Objects.requireNonNull(address);
        Objects.requireNonNull(message);
        Objects.requireNonNull(promise);
        message.setSender(this.address);
        ChannelFuture channelFuture = this.outgoingChannels.computeIfAbsent(address, this::connect);
        if (channelFuture.isSuccess()) {
            this.send(channelFuture.channel(), message, promise);
        } else {
            channelFuture.addListener(chFuture -> {
                if (chFuture.isSuccess()) {
                    this.send(channelFuture.channel(), message, promise);
                } else {
                    promise.completeExceptionally(chFuture.cause());
                }
            });
        }
    }

    private void send(Channel channel, Message message, CompletableFuture<Void> promise) {
        if (promise.equals(COMPLETED_PROMISE)) {
            channel.writeAndFlush((Object)message, channel.voidPromise());
        } else {
            this.composeFutures(channel.writeAndFlush((Object)message), promise);
        }
    }

    private void composeFutures(ChannelFuture channelFuture, CompletableFuture<Void> promise) {
        channelFuture.addListener(future -> {
            if (channelFuture.isSuccess()) {
                promise.complete((Void)channelFuture.get());
            } else {
                promise.completeExceptionally(channelFuture.cause());
            }
        });
    }

    private ChannelFuture connect(Address address) {
        return ((Bootstrap)this.bootstrapFactory.clientBootstrap().handler((ChannelHandler)new OutgoingChannelInitializer(address))).connect(address.host(), address.port()).addListener(channelFuture -> {
            if (channelFuture.isSuccess()) {
                LOGGER.debug("Connected from {} to {}: {}", new Object[]{this.address, address, ((ChannelFuture)channelFuture).channel()});
            } else {
                LOGGER.warn("Failed to connect from {} to {}", (Object)this.address, (Object)address);
                this.outgoingChannels.remove(address);
            }
        });
    }

    private static Address toAddress(SocketAddress address) {
        InetSocketAddress inetAddress = (InetSocketAddress)address;
        return Address.create(inetAddress.getHostString(), inetAddress.getPort());
    }

    @ChannelHandler.Sharable
    private final class OutgoingChannelInitializer
    extends ChannelInitializer {
        private final Address address;

        public OutgoingChannelInitializer(Address address) {
            this.address = address;
        }

        protected void initChannel(Channel channel) {
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast(new ChannelHandler[]{new ChannelDuplexHandler(){

                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                    LOGGER.debug("Disconnected from: {} {}", (Object)OutgoingChannelInitializer.this.address, (Object)ctx.channel());
                    TransportImpl.this.outgoingChannels.remove(OutgoingChannelInitializer.this.address);
                    super.channelInactive(ctx);
                }
            }});
            pipeline.addLast(new ChannelHandler[]{new ProtobufVarint32LengthFieldPrepender()});
            pipeline.addLast(new ChannelHandler[]{TransportImpl.this.serializerHandler});
            if (TransportImpl.this.networkEmulatorHandler != null) {
                pipeline.addLast(new ChannelHandler[]{TransportImpl.this.networkEmulatorHandler});
            }
            pipeline.addLast(new ChannelHandler[]{TransportImpl.this.exceptionHandler});
        }
    }

    @ChannelHandler.Sharable
    private final class IncomingChannelInitializer
    extends ChannelInitializer {
        private IncomingChannelInitializer() {
        }

        protected void initChannel(Channel channel) {
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast(new ChannelHandler[]{new ProtobufVarint32FrameDecoder()});
            pipeline.addLast(new ChannelHandler[]{TransportImpl.this.deserializerHandler});
            pipeline.addLast(new ChannelHandler[]{TransportImpl.this.messageHandler});
            pipeline.addLast(new ChannelHandler[]{TransportImpl.this.exceptionHandler});
        }
    }
}

