/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import io.scalecube.transport.Address;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class Message {
    public static final String HEADER_QUALIFIER = "q";
    public static final String HEADER_CORRELATION_ID = "cid";
    public static final String HEADER_DATA_TYPE = "_type";
    private Map<String, String> headers = Collections.emptyMap();
    private Object data;
    private Address sender;

    Message() {
    }

    private Message(Builder builder) {
        this.data = builder.data();
        this.headers = builder.headers();
    }

    public static Message fromData(Object data) {
        return Message.withData(data).build();
    }

    public static Builder withData(Object data) {
        return Message.builder().data(data);
    }

    public static Message fromHeaders(Map<String, String> headers) {
        return Message.withHeaders(headers).build();
    }

    public static Builder withHeaders(Map<String, String> headers) {
        return Message.builder().headers(headers);
    }

    public static Message fromQualifier(String qualifier) {
        return Message.withQualifier(qualifier).build();
    }

    public static Builder withQualifier(String qualifier) {
        return Message.builder().qualifier(qualifier);
    }

    public static Message from(Message message) {
        return Message.with(message).build();
    }

    public static Builder with(Message message) {
        return Message.withData(message.data).headers(message.headers);
    }

    public static Builder builder() {
        return Builder.getInstance();
    }

    void setData(Object data) {
        this.data = data;
    }

    void setHeaders(Map<String, String> headers) {
        this.headers = Collections.unmodifiableMap(Objects.requireNonNull(headers));
    }

    void setSender(Address sender) {
        this.sender = sender;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public String header(String name) {
        return this.headers.get(name);
    }

    public String qualifier() {
        return this.header(HEADER_QUALIFIER);
    }

    public String correlationId() {
        return this.header(HEADER_CORRELATION_ID);
    }

    public <T> T data() {
        return (T)this.data;
    }

    public Address sender() {
        return this.sender;
    }

    public String toString() {
        return "Message {headers: " + this.headers + ", sender: " + this.sender + ", data: " + this.data + '}';
    }

    public static class Builder {
        private Map<String, String> headers = new HashMap<String, String>();
        private Object data;

        private Builder() {
        }

        static Builder getInstance() {
            return new Builder();
        }

        private Object data() {
            return this.data;
        }

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        private Map<String, String> headers() {
            return this.headers;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder header(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder qualifier(String qualifier) {
            return this.header(Message.HEADER_QUALIFIER, qualifier);
        }

        public Builder correlationId(String correlationId) {
            return this.header(Message.HEADER_CORRELATION_ID, correlationId);
        }

        public Message build() {
            return new Message(this);
        }
    }
}

