/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import io.scalecube.transport.Address;
import io.scalecube.transport.NetworkLinkSettings;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkEmulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkEmulator.class);
    public static final NetworkLinkSettings DEAD_LINK_SETTINGS = new NetworkLinkSettings(100, 0);
    public static final NetworkLinkSettings ALIVE_LINK_SETTINGS = new NetworkLinkSettings(0, 0);
    private volatile NetworkLinkSettings defaultLinkSettings = ALIVE_LINK_SETTINGS;
    private final Map<Address, NetworkLinkSettings> customLinkSettings = new ConcurrentHashMap<Address, NetworkLinkSettings>();
    private final AtomicLong totalMessageSentCount = new AtomicLong();
    private final AtomicLong totalMessageLostCount = new AtomicLong();
    private final boolean enabled;
    private final Address address;

    NetworkEmulator(Address address, boolean enabled) {
        this.address = address;
        this.enabled = enabled;
    }

    public NetworkLinkSettings getLinkSettings(Address destination) {
        return this.customLinkSettings.getOrDefault(destination, this.defaultLinkSettings);
    }

    public NetworkLinkSettings getLinkSettings(InetSocketAddress address) {
        Address address1 = Address.create(address.getHostName(), address.getPort());
        if (this.customLinkSettings.containsKey(address1)) {
            return this.customLinkSettings.get(address1);
        }
        Address address2 = Address.create(address.getAddress().getHostAddress(), address.getPort());
        if (this.customLinkSettings.containsKey(address2)) {
            return this.customLinkSettings.get(address2);
        }
        return this.defaultLinkSettings;
    }

    public void setLinkSettings(Address destination, int lossPercent, int meanDelay) {
        if (!this.enabled) {
            LOGGER.warn("Can't set network settings (loss={}%, mean={}ms) from {} to {} since network emulator is disabled", new Object[]{lossPercent, meanDelay, this.address, destination});
            return;
        }
        NetworkLinkSettings settings = new NetworkLinkSettings(lossPercent, meanDelay);
        this.customLinkSettings.put(destination, settings);
        LOGGER.info("Set network settings (loss={}%, mean={}ms) from {} to {}", new Object[]{lossPercent, meanDelay, this.address, destination});
    }

    public void setDefaultLinkSettings(int lossPercent, int meanDelay) {
        if (!this.enabled) {
            LOGGER.warn("Can't set default network settings (loss={}%, mean={}ms) for {} since network emulator is disabled", new Object[]{lossPercent, meanDelay, this.address});
            return;
        }
        this.defaultLinkSettings = new NetworkLinkSettings(lossPercent, meanDelay);
        LOGGER.info("Set default network settings (loss={}%, mean={}ms) for {}", new Object[]{lossPercent, meanDelay, this.address});
    }

    public void block(Address ... destinations) {
        this.block(Arrays.asList(destinations));
    }

    public void block(Collection<Address> destinations) {
        if (!this.enabled) {
            LOGGER.warn("Can't block network from {} to {} since network emulator is disabled");
            return;
        }
        for (Address destination : destinations) {
            this.customLinkSettings.put(destination, DEAD_LINK_SETTINGS);
        }
        LOGGER.info("Blocked network from {} to {}", (Object)this.address, destinations);
    }

    public void unblock(Address ... destinations) {
        this.unblock(Arrays.asList(destinations));
    }

    public void unblock(Collection<Address> destinations) {
        if (!this.enabled) {
            LOGGER.warn("Can't unblock network from {} to {} since network emulator is disabled", (Object)this.address, destinations);
            return;
        }
        for (Address destination : destinations) {
            this.customLinkSettings.remove(destination);
        }
        LOGGER.info("Unblocked network from {} to {}", (Object)this.address, destinations);
    }

    public void unblockAll() {
        if (!this.enabled) {
            LOGGER.warn("Can't unblock network from {} since network emulator is disabled", (Object)this.address);
            return;
        }
        this.customLinkSettings.clear();
        LOGGER.info("Unblocked all network from {}", (Object)this.address);
    }

    public long totalMessageSentCount() {
        if (!this.enabled) {
            LOGGER.warn("Can't compute total messages sent from {} since network emulator is disabled", (Object)this.address);
            return 0L;
        }
        return this.totalMessageSentCount.get();
    }

    public long totalMessageLostCount() {
        if (!this.enabled) {
            LOGGER.warn("Can't compute total messages lost from {} since network emulator is disabled", (Object)this.address);
            return 0L;
        }
        return this.totalMessageLostCount.get();
    }

    void incrementMessageSentCount() {
        if (!this.enabled) {
            LOGGER.warn("since network emulator is disabled");
            return;
        }
        this.totalMessageSentCount.incrementAndGet();
    }

    void incrementMessageLostCount() {
        if (!this.enabled) {
            LOGGER.warn("since network emulator is disabled");
            return;
        }
        this.totalMessageLostCount.incrementAndGet();
    }
}

