/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import io.scalecube.transport.Message;
import io.scalecube.transport.MessageSchema;
import io.scalecube.transport.RecyclableLinkedBuffer;
import java.io.InputStream;
import java.io.OutputStream;

public final class MessageCodec {
    private static final RecyclableLinkedBuffer recyclableLinkedBuffer = new RecyclableLinkedBuffer();

    private MessageCodec() {
    }

    public static Message deserialize(ByteBuf bb) {
        Schema schema = RuntimeSchema.getSchema(Message.class);
        Message message = (Message)schema.newMessage();
        try {
            ProtostuffIOUtil.mergeFrom((InputStream)new ByteBufInputStream(bb), (Object)message, (Schema)schema);
        }
        catch (Exception e) {
            throw new DecoderException(e.getMessage(), (Throwable)e);
        }
        return message;
    }

    public static void serialize(Message message, ByteBuf bb) {
        Schema schema = RuntimeSchema.getSchema(Message.class);
        try (RecyclableLinkedBuffer rlb = recyclableLinkedBuffer.get();){
            try {
                ProtostuffIOUtil.writeTo((OutputStream)new ByteBufOutputStream(bb), (Object)message, (Schema)schema, (LinkedBuffer)rlb.buffer());
            }
            catch (Exception e) {
                throw new EncoderException(e.getMessage(), (Throwable)e);
            }
        }
    }

    static {
        if (!RuntimeSchema.isRegistered(Message.class)) {
            RuntimeSchema.register(Message.class, (Schema)new MessageSchema());
        }
    }
}

