/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport.memoizer;

import io.scalecube.transport.memoizer.MemoizerExecutionException;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Function;

public class Memoizer<A, V> {
    private final ConcurrentMap<A, CompletableFuture<V>> cache = new ConcurrentHashMap<A, CompletableFuture<V>>();
    private final Function<A, V> defaultComputable;

    public Memoizer() {
        this(null);
    }

    public Memoizer(Function<A, V> defaultComputable) {
        this.defaultComputable = defaultComputable;
    }

    public V get(A arg) throws MemoizerExecutionException {
        return this.get(arg, this.defaultComputable);
    }

    public V get(A arg, Executor executor) throws MemoizerExecutionException {
        return this.get(arg, this.defaultComputable, executor);
    }

    public V get(A arg, Function<A, V> computable) throws MemoizerExecutionException {
        return this.get(arg, computable, Runnable::run);
    }

    public V get(A arg, Function<A, V> computable, Executor executor) throws MemoizerExecutionException {
        while (true) {
            CompletableFuture<V> future = this.getAsync(arg, computable, executor);
            try {
                return future.get();
            }
            catch (InterruptedException | CancellationException e) {
                this.cache.remove(arg, future);
                continue;
            }
            catch (ExecutionException e) {
                this.cache.remove(arg, future);
                throw new MemoizerExecutionException("Failed to compute value for key: " + arg + " with computable: " + computable, e.getCause());
            }
            break;
        }
    }

    public CompletableFuture<V> getAsync(A arg, Executor executor) {
        return this.getAsync(arg, this.defaultComputable, executor);
    }

    public CompletableFuture<V> getAsync(A arg, Function<A, V> computable, Executor executor) {
        CompletableFuture compute;
        CompletionStage future = (CompletableFuture)this.cache.get(arg);
        if (future == null && (future = this.cache.putIfAbsent(arg, compute = new CompletableFuture())) == null) {
            future = CompletableFuture.supplyAsync(() -> computable.apply(arg), executor).thenCompose(x -> {
                compute.complete(x);
                return compute;
            });
        }
        return future;
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public V getIfExists(A arg) throws MemoizerExecutionException {
        return this.containsKey(arg) ? (V)this.get(arg) : null;
    }

    public V remove(A arg) {
        Future future = (Future)this.cache.remove(arg);
        V res = null;
        if (future != null) {
            try {
                res = future.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        return res;
    }

    public void delete(A arg) {
        this.cache.remove(arg);
    }

    public boolean containsKey(A arg) {
        return this.cache.containsKey(arg);
    }

    public Set<A> keySet() {
        return this.cache.keySet();
    }

    public void clear() {
        this.cache.clear();
    }
}

