/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import java.util.concurrent.ThreadLocalRandom;

public final class NetworkEmulatorSettings {
    private final int lostPercent;
    private final int meanDelay;

    public NetworkEmulatorSettings(int lostPercent, int mean) {
        this.lostPercent = lostPercent;
        this.meanDelay = mean;
    }

    public int getLostPercent() {
        return this.lostPercent;
    }

    public int getMeanDelay() {
        return this.meanDelay;
    }

    public boolean evaluateLost() {
        return this.lostPercent > 0 && (this.lostPercent >= 100 || ThreadLocalRandom.current().nextInt(100) < this.lostPercent);
    }

    public long evaluateDelay() {
        if (this.meanDelay > 0) {
            Double x0 = ThreadLocalRandom.current().nextDouble();
            Double y0 = -Math.log(1.0 - x0) * (double)this.meanDelay;
            return y0.longValue();
        }
        return 0L;
    }

    public String toString() {
        return "NetworkEmulatorSettings{lostPercent=" + this.lostPercent + ", meanDelay=" + this.meanDelay + '}';
    }
}

