/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.scalecube.transport.Address;
import io.scalecube.transport.NetworkEmulatorSettings;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
final class NetworkEmulatorHandler
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkEmulatorHandler.class);
    private final Map<Address, NetworkEmulatorSettings> networkSettings = new ConcurrentHashMap<Address, NetworkEmulatorSettings>();
    private NetworkEmulatorSettings defaultSettings = new NetworkEmulatorSettings(0, 0);

    NetworkEmulatorHandler() {
    }

    public void write(final ChannelHandlerContext ctx, final Object msg, final ChannelPromise promise) throws Exception {
        NetworkEmulatorSettings networkSettings = this.resolveNetworkSettings(ctx.channel());
        boolean isLost = networkSettings.evaluateLost();
        if (isLost) {
            if (promise != null) {
                promise.setFailure((Throwable)new RuntimeException("NETWORK_BREAK detected, not sent " + msg));
            }
            return;
        }
        int delay = (int)networkSettings.evaluateDelay();
        if (delay > 0) {
            block5: {
                try {
                    ctx.channel().eventLoop().schedule((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            ctx.writeAndFlush(msg, promise);
                            return null;
                        }
                    }, (long)delay, TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException e) {
                    if (promise == null) break block5;
                    String warn = "Rejected " + msg + " on " + ctx.channel();
                    LOGGER.warn(warn);
                    promise.setFailure((Throwable)new RuntimeException(warn, e));
                }
            }
            return;
        }
        super.write(ctx, msg, promise);
    }

    private NetworkEmulatorSettings resolveNetworkSettings(Channel channel) {
        InetSocketAddress remoteSocketAddress = (InetSocketAddress)channel.remoteAddress();
        Address remoteAddress = Address.create(remoteSocketAddress.getHostName(), remoteSocketAddress.getPort());
        return this.networkSettings.containsKey(remoteAddress) ? this.networkSettings.get(remoteAddress) : this.defaultSettings;
    }

    public void setNetworkSettings(Address destination, int lostPercent, int mean) {
        NetworkEmulatorSettings settings = new NetworkEmulatorSettings(lostPercent, mean);
        this.networkSettings.put(destination, settings);
        LOGGER.debug("Set {} for messages to: {}", (Object)settings, (Object)destination);
    }

    public void setDefaultNetworkSettings(int lostPercent, int delay) {
        this.defaultSettings = new NetworkEmulatorSettings(lostPercent, delay);
        LOGGER.debug("Set default {}", (Object)this.defaultSettings);
    }

    public void block(Address destination) {
        this.networkSettings.put(destination, new NetworkEmulatorSettings(100, 0));
        LOGGER.debug("Block messages to: {}", (Object)destination);
    }

    public void block(Collection<Address> destinations) {
        for (Address destination : destinations) {
            this.networkSettings.put(destination, new NetworkEmulatorSettings(100, 0));
        }
        LOGGER.debug("Block messages to: {}", destinations);
    }

    public void unblock(Address destination) {
        this.networkSettings.remove(destination);
        LOGGER.debug("Unblock messages to: {}", (Object)destination);
    }

    public void unblockAll() {
        this.networkSettings.clear();
        LOGGER.debug("Unblock all messages");
    }
}

