/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import com.google.common.collect.ImmutableMap;
import io.protostuff.Input;
import io.protostuff.LinkedBuffer;
import io.protostuff.Output;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import io.scalecube.transport.Address;
import io.scalecube.transport.Message;
import io.scalecube.transport.RecyclableLinkedBuffer;
import io.scalecube.transport.memoizer.Memoizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MessageSchema
implements Schema<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageSchema.class);
    private static final int HEADER_KEYS_FIELD_NUMBER = 1;
    private static final int HEADER_VALUES_FIELD_NUMBER = 2;
    private static final int DATA_FIELD_NUMBER = 3;
    private static final int SENDER_HOST_FIELD_NUMBER = 4;
    private static final int SENDER_PORT_FIELD_NUMBER = 5;
    private static final RecyclableLinkedBuffer recyclableLinkedBuffer = new RecyclableLinkedBuffer(256, 256);
    private static final Map<String, Integer> fieldMap = ImmutableMap.builder().put((Object)"headerKeys", (Object)1).put((Object)"headerValues", (Object)2).put((Object)"data", (Object)3).put((Object)"senderHost", (Object)4).put((Object)"senderPort", (Object)5).build();
    private final Memoizer<String, Optional<Class>> classCache = new Memoizer<String, Optional>(className -> {
        try {
            Class<?> dataClass = Class.forName(className);
            return Optional.of(dataClass);
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    });

    MessageSchema() {
    }

    public String getFieldName(int number) {
        switch (number) {
            case 1: {
                return "headerKeys";
            }
            case 2: {
                return "headerValues";
            }
            case 3: {
                return "data";
            }
            case 4: {
                return "senderHost";
            }
            case 5: {
                return "senderPort";
            }
        }
        return null;
    }

    public int getFieldNumber(String name) {
        return fieldMap.get(name);
    }

    public boolean isInitialized(Message message) {
        return message != null;
    }

    public Message newMessage() {
        return new Message();
    }

    public String messageName() {
        return Message.class.getSimpleName();
    }

    public String messageFullName() {
        return Message.class.getName();
    }

    public Class<? super Message> typeClass() {
        return Message.class;
    }

    public void mergeFrom(Input input, Message message) throws IOException {
        boolean iterate = true;
        ArrayList<String> headerKeys = new ArrayList<String>();
        ArrayList<String> headerValues = new ArrayList<String>();
        String senderHost = null;
        int senderPort = 0;
        byte[] dataBytes = null;
        block10: while (iterate) {
            int number = input.readFieldNumber((Schema)this);
            switch (number) {
                case 0: {
                    iterate = false;
                    continue block10;
                }
                case 1: {
                    headerKeys.add(input.readString());
                    continue block10;
                }
                case 2: {
                    headerValues.add(input.readString());
                    continue block10;
                }
                case 3: {
                    dataBytes = input.readByteArray();
                    continue block10;
                }
                case 4: {
                    senderHost = input.readString();
                    continue block10;
                }
                case 5: {
                    senderPort = input.readInt32();
                    continue block10;
                }
            }
            input.handleUnknownField(number, (Schema)this);
        }
        HashMap<String, String> headers = new HashMap<String, String>(headerKeys.size());
        if (!headerKeys.isEmpty()) {
            ListIterator headerValuesIterator = headerValues.listIterator();
            for (String key : headerKeys) {
                String value = (String)headerValuesIterator.next();
                headers.put(key, value);
            }
        }
        Object data = null;
        if (dataBytes != null) {
            String dataType = (String)headers.get("_type");
            if (dataType == null) {
                data = dataBytes;
            } else {
                Optional<Class> optionalDataClass = this.classCache.get(dataType);
                if (optionalDataClass.isPresent()) {
                    headers.remove("_type");
                    Class dataClass = optionalDataClass.get();
                    Schema dataSchema = RuntimeSchema.getSchema((Class)dataClass);
                    data = dataSchema.newMessage();
                    try {
                        ProtostuffIOUtil.mergeFrom((byte[])dataBytes, (Object)data, (Schema)dataSchema);
                    }
                    catch (Throwable e) {
                        LOGGER.error("Failed to deserialize : {}", (Object)message);
                        throw e;
                    }
                } else {
                    data = dataBytes;
                }
            }
        }
        Address sender = senderHost != null ? Address.create(senderHost, senderPort) : null;
        message.setHeaders(headers);
        message.setData(data);
        message.setSender(sender);
    }

    public void writeTo(Output output, Message message) throws IOException {
        Address sender;
        Object originalData;
        if (!message.headers().isEmpty()) {
            for (Map.Entry<String, String> headerEntry : message.headers().entrySet()) {
                if (headerEntry.getKey() == null || headerEntry.getValue() == null) continue;
                output.writeString(1, headerEntry.getKey(), true);
                output.writeString(2, headerEntry.getValue(), true);
            }
        }
        if ((originalData = message.data()) != null) {
            if (originalData instanceof byte[]) {
                output.writeByteArray(3, (byte[])originalData, false);
            } else {
                Class<?> dataClass = originalData.getClass();
                output.writeString(1, "_type", true);
                output.writeString(2, dataClass.getName(), true);
                Schema dataSchema = RuntimeSchema.getSchema(dataClass);
                try (RecyclableLinkedBuffer rlb = recyclableLinkedBuffer.get();){
                    byte[] array = ProtostuffIOUtil.toByteArray(originalData, (Schema)dataSchema, (LinkedBuffer)rlb.buffer());
                    output.writeByteArray(3, array, false);
                }
            }
        }
        if ((sender = message.sender()) != null) {
            output.writeString(4, sender.host(), false);
            output.writeInt32(5, sender.port(), false);
        }
    }
}

