/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.scalecube.transport.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.subjects.Subject;

@ChannelHandler.Sharable
final class MessageReceiverHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageReceiverHandler.class);
    private final Subject<Message, Message> incomingMessagesSubject;

    MessageReceiverHandler(Subject<Message, Message> incomingMessagesSubject) {
        this.incomingMessagesSubject = incomingMessagesSubject;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Message message = (Message)msg;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received: {}", (Object)message);
        }
        this.incomingMessagesSubject.onNext((Object)message);
    }
}

