/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;

final class Addressing {
    static final int MIN_PORT_NUMBER = 1100;
    static final int MAX_PORT_NUMBER = 49151;

    private Addressing() {
    }

    static int getNextAvailablePort(InetAddress inetAddress, int fromPort, int portCount) {
        int toPort = Math.min(49151, fromPort + portCount) - 1;
        for (int port = fromPort; port <= toPort; ++port) {
            if (!Addressing.isAvailablePort(inetAddress, port)) continue;
            return port;
        }
        throw new NoSuchElementException("Could not find an available port from " + fromPort + " to " + toPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isAvailablePort(InetAddress inetAddress, int port) {
        if (port < 1100 || port > 49151) {
            throw new IllegalArgumentException("Invalid port number: " + port);
        }
        Socket socket = null;
        try {
            socket = new Socket(inetAddress, port);
            boolean bl = false;
            return bl;
        }
        catch (IOException ignore) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static InetAddress getLocalIpAddress(String listenAddress, String listenInterface, boolean preferIPv6) {
        InetAddress ipAddress;
        if (!Strings.isNullOrEmpty((String)listenAddress) && !Strings.isNullOrEmpty((String)listenInterface)) {
            throw new IllegalArgumentException("Not allowed to set both listenAddress and listenInterface, choose one");
        }
        if (!Strings.isNullOrEmpty((String)listenAddress)) {
            try {
                ipAddress = InetAddress.getByName(listenAddress);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Unknown listenAddress: " + listenAddress);
            }
            if (ipAddress.isAnyLocalAddress()) {
                throw new IllegalArgumentException("listenAddress: " + listenAddress + " cannot be a wildcard address");
            }
            if (!Addressing.isValidLocalIpAddress(ipAddress)) {
                throw new IllegalArgumentException("listenAddress: " + listenAddress + " doesn't belong to any active network interface");
            }
        } else {
            ipAddress = !Strings.isNullOrEmpty((String)listenInterface) ? Addressing.getNetworkInterfaceIpAddress(listenInterface, preferIPv6) : Addressing.getLocalIpAddress();
        }
        return ipAddress;
    }

    static InetAddress getLocalIpAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static InetAddress getNetworkInterfaceIpAddress(String listenInterface, boolean preferIPv6) {
        try {
            NetworkInterface ni = NetworkInterface.getByName(listenInterface);
            if (ni == null) {
                throw new IllegalArgumentException("Configured network interface: " + listenInterface + " could not be found");
            }
            if (!ni.isUp()) {
                throw new IllegalArgumentException("Configured network interface: " + listenInterface + " is not active");
            }
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            if (!addrs.hasMoreElements()) {
                throw new IllegalArgumentException("Configured network interface: " + listenInterface + " was found, but had no addresses");
            }
            InetAddress result = null;
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (preferIPv6 && addr instanceof Inet6Address) {
                    return addr;
                }
                if (!preferIPv6 && addr instanceof Inet4Address) {
                    return addr;
                }
                if (result != null) continue;
                result = addr;
            }
            return result;
        }
        catch (SocketException e) {
            throw new IllegalArgumentException("Configured network interface: " + listenInterface + " caused an exception", e);
        }
    }

    static boolean isValidLocalIpAddress(InetAddress listenAddress) {
        ArrayList<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
        }
        catch (SocketException e) {
            throw new IllegalArgumentException("Can't get list of network interfaces", e);
        }
        for (NetworkInterface ni : networkInterfaces) {
            try {
                if (!ni.isUp()) continue;
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!addr.getHostAddress().equals(listenAddress.getHostAddress())) continue;
                    return true;
                }
            }
            catch (SocketException e) {
                throw new IllegalArgumentException("Network interface: " + ni + " caused an exception", e);
            }
        }
        return false;
    }
}

