/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.gateway.transport.rsocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.rsocket.Payload;
import io.rsocket.util.ByteBufPayload;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.exceptions.MessageCodecException;
import io.scalecube.services.gateway.transport.GatewayClientCodec;
import io.scalecube.services.transport.api.DataCodec;
import io.scalecube.services.transport.api.HeadersCodec;
import io.scalecube.services.transport.api.ReferenceCountUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RSocketGatewayClientCodec
implements GatewayClientCodec<Payload> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSocketGatewayClientCodec.class);
    private final HeadersCodec headersCodec;
    private final DataCodec dataCodec;

    public RSocketGatewayClientCodec(HeadersCodec headersCodec, DataCodec dataCodec) {
        this.headersCodec = headersCodec;
        this.dataCodec = dataCodec;
    }

    @Override
    public DataCodec getDataCodec() {
        return this.dataCodec;
    }

    @Override
    public Payload encode(ServiceMessage message) {
        return this.encodeAndTransform(message, ByteBufPayload::create);
    }

    @Override
    public ServiceMessage decode(Payload encodedMessage) {
        return this.decode(encodedMessage.sliceData(), encodedMessage.sliceMetadata());
    }

    private ServiceMessage decode(ByteBuf dataBuffer, ByteBuf headersBuffer) throws MessageCodecException {
        ServiceMessage.Builder builder = ServiceMessage.builder();
        if (dataBuffer.isReadable()) {
            builder.data((Object)dataBuffer);
        }
        if (headersBuffer.isReadable()) {
            try (ByteBufInputStream stream = new ByteBufInputStream(headersBuffer, true);){
                builder.headers(this.headersCodec.decode((InputStream)stream));
            }
            catch (Throwable ex) {
                ReferenceCountUtil.safestRelease((Object)dataBuffer);
                throw new MessageCodecException("Failed to decode message headers", ex);
            }
        }
        return builder.build();
    }

    private <T> T encodeAndTransform(ServiceMessage message, BiFunction<ByteBuf, ByteBuf, T> transformer) throws MessageCodecException {
        ByteBuf dataBuffer = Unpooled.EMPTY_BUFFER;
        ByteBuf headersBuffer = Unpooled.EMPTY_BUFFER;
        if (message.hasData(ByteBuf.class)) {
            dataBuffer = (ByteBuf)message.data();
        } else if (message.hasData()) {
            dataBuffer = ByteBufAllocator.DEFAULT.buffer();
            try {
                this.dataCodec.encode((OutputStream)new ByteBufOutputStream(dataBuffer), message.data());
            }
            catch (Throwable ex) {
                ReferenceCountUtil.safestRelease((Object)dataBuffer);
                LOGGER.error("Failed to encode data on: {}, cause: {}", (Object)message, (Object)ex);
                throw new MessageCodecException("Failed to encode data on message q=" + message.qualifier(), ex);
            }
        }
        if (!message.headers().isEmpty()) {
            headersBuffer = ByteBufAllocator.DEFAULT.buffer();
            try {
                this.headersCodec.encode((OutputStream)new ByteBufOutputStream(headersBuffer), message.headers());
            }
            catch (Throwable ex) {
                ReferenceCountUtil.safestRelease((Object)headersBuffer);
                ReferenceCountUtil.safestRelease((Object)dataBuffer);
                LOGGER.error("Failed to encode headers on: {}, cause: {}", (Object)message, (Object)ex);
                throw new MessageCodecException("Failed to encode headers on message q=" + message.qualifier(), ex);
            }
        }
        return transformer.apply(dataBuffer, headersBuffer);
    }
}

