/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.gateway.transport;

import io.netty.buffer.ByteBuf;
import io.rsocket.Payload;
import io.scalecube.services.gateway.transport.GatewayClient;
import io.scalecube.services.gateway.transport.GatewayClientCodec;
import io.scalecube.services.gateway.transport.GatewayClientSettings;
import io.scalecube.services.gateway.transport.GatewayClientTransport;
import io.scalecube.services.gateway.transport.http.HttpGatewayClient;
import io.scalecube.services.gateway.transport.http.HttpGatewayClientCodec;
import io.scalecube.services.gateway.transport.rsocket.RSocketGatewayClient;
import io.scalecube.services.gateway.transport.rsocket.RSocketGatewayClientCodec;
import io.scalecube.services.gateway.transport.websocket.WebsocketGatewayClient;
import io.scalecube.services.gateway.transport.websocket.WebsocketGatewayClientCodec;
import io.scalecube.services.transport.api.ClientTransport;
import io.scalecube.services.transport.api.DataCodec;
import io.scalecube.services.transport.api.HeadersCodec;
import java.util.function.Function;

public class GatewayClientTransports {
    private static final String CONTENT_TYPE = "application/json";
    private static final HeadersCodec HEADERS_CODEC = HeadersCodec.getInstance((String)"application/json");
    public static final GatewayClientCodec<ByteBuf> WEBSOCKET_CLIENT_CODEC = new WebsocketGatewayClientCodec(DataCodec.getInstance((String)"application/json"));
    public static final GatewayClientCodec<Payload> RSOCKET_CLIENT_CODEC = new RSocketGatewayClientCodec(HEADERS_CODEC, DataCodec.getInstance((String)"application/json"));
    public static final GatewayClientCodec<ByteBuf> HTTP_CLIENT_CODEC = new HttpGatewayClientCodec(DataCodec.getInstance((String)"application/json"));

    private GatewayClientTransports() {
    }

    public static ClientTransport rsocketGatewayClientTransport(GatewayClientSettings cs) {
        Function<GatewayClientSettings, GatewayClient> function = settings -> new RSocketGatewayClient((GatewayClientSettings)settings, RSOCKET_CLIENT_CODEC);
        return new GatewayClientTransport(function.apply(cs));
    }

    public static ClientTransport websocketGatewayClientTransport(GatewayClientSettings cs) {
        Function<GatewayClientSettings, GatewayClient> function = settings -> new WebsocketGatewayClient((GatewayClientSettings)settings, WEBSOCKET_CLIENT_CODEC);
        return new GatewayClientTransport(function.apply(cs));
    }

    public static ClientTransport httpGatewayClientTransport(GatewayClientSettings cs) {
        Function<GatewayClientSettings, GatewayClient> function = settings -> new HttpGatewayClient((GatewayClientSettings)settings, HTTP_CLIENT_CODEC);
        return new GatewayClientTransport(function.apply(cs));
    }
}

