/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.gateway.transport;

import io.scalecube.net.Address;
import io.scalecube.services.exceptions.DefaultErrorMapper;
import io.scalecube.services.exceptions.ServiceClientErrorMapper;
import reactor.netty.tcp.SslProvider;

public class GatewayClientSettings {
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_CONTENT_TYPE = "application/json";
    private final String host;
    private final int port;
    private final String contentType;
    private final boolean followRedirect;
    private final SslProvider sslProvider;
    private final ServiceClientErrorMapper errorMapper;

    private GatewayClientSettings(Builder builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.contentType = builder.contentType;
        this.followRedirect = builder.followRedirect;
        this.sslProvider = builder.sslProvider;
        this.errorMapper = builder.errorMapper;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String contentType() {
        return this.contentType;
    }

    public boolean followRedirect() {
        return this.followRedirect;
    }

    public SslProvider sslProvider() {
        return this.sslProvider;
    }

    public ServiceClientErrorMapper errorMapper() {
        return this.errorMapper;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(GatewayClientSettings gatewayClientSettings) {
        return new Builder(gatewayClientSettings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GatewayClientSettings{");
        sb.append("host='").append(this.host).append('\'');
        sb.append(", port=").append(this.port);
        sb.append(", contentType='").append(this.contentType).append('\'');
        sb.append(", followRedirect=").append(this.followRedirect);
        sb.append(", sslProvider=").append(this.sslProvider);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private String host = "localhost";
        private int port;
        private String contentType = "application/json";
        private boolean followRedirect = true;
        private SslProvider sslProvider;
        private ServiceClientErrorMapper errorMapper = DefaultErrorMapper.INSTANCE;

        private Builder() {
        }

        private Builder(GatewayClientSettings originalSettings) {
            this.host = originalSettings.host;
            this.port = originalSettings.port;
            this.contentType = originalSettings.contentType;
            this.followRedirect = originalSettings.followRedirect;
            this.sslProvider = originalSettings.sslProvider;
            this.errorMapper = originalSettings.errorMapper;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder address(Address address) {
            return this.host(address.host()).port(address.port());
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder followRedirect(boolean followRedirect) {
            this.followRedirect = followRedirect;
            return this;
        }

        public Builder secure() {
            this.sslProvider = SslProvider.defaultClientProvider();
            return this;
        }

        public Builder secure(SslProvider sslProvider) {
            this.sslProvider = sslProvider;
            return this;
        }

        public Builder errorMapper(ServiceClientErrorMapper errorMapper) {
            this.errorMapper = errorMapper;
            return this;
        }

        public GatewayClientSettings build() {
            return new GatewayClientSettings(this);
        }
    }
}

