/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import io.scalecube.services.api.ErrorData;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.codec.DataCodec;
import io.scalecube.services.codec.HeadersCodec;
import io.scalecube.services.exceptions.ExceptionProcessor;
import io.scalecube.services.exceptions.MessageCodecException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceMessageCodec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceMessageCodec.class);
    private static final String DEFAULT_DATA_FORMAT = "application/json";
    private final HeadersCodec headersCodec;

    public ServiceMessageCodec(HeadersCodec headersCodec) {
        this.headersCodec = headersCodec;
    }

    public <T> T encodeAndTransform(ServiceMessage message, BiFunction<ByteBuf, ByteBuf, T> transformer) throws MessageCodecException {
        ByteBuf dataBuffer = Unpooled.EMPTY_BUFFER;
        ByteBuf headersBuffer = Unpooled.EMPTY_BUFFER;
        if (message.hasData(ByteBuf.class)) {
            dataBuffer = (ByteBuf)message.data();
        } else if (message.hasData()) {
            dataBuffer = ByteBufAllocator.DEFAULT.buffer();
            try {
                String contentType = Optional.ofNullable(message.dataFormat()).orElse(DEFAULT_DATA_FORMAT);
                DataCodec dataCodec = DataCodec.getInstance(contentType);
                dataCodec.encode((OutputStream)new ByteBufOutputStream(dataBuffer), message.data());
            }
            catch (Throwable ex) {
                ReferenceCountUtil.safeRelease((Object)dataBuffer);
                LOGGER.error("Failed to encode data on: {}, cause: {}", (Object)message, (Object)ex);
                throw new MessageCodecException("Failed to encode data on message q=" + message.qualifier(), ex);
            }
        }
        if (!message.headers().isEmpty()) {
            headersBuffer = ByteBufAllocator.DEFAULT.buffer();
            try {
                this.headersCodec.encode((OutputStream)new ByteBufOutputStream(headersBuffer), message.headers());
            }
            catch (Throwable ex) {
                ReferenceCountUtil.safeRelease((Object)headersBuffer);
                LOGGER.error("Failed to encode headers on: {}, cause: {}", (Object)message, (Object)ex);
                throw new MessageCodecException("Failed to encode headers on message q=" + message.qualifier(), ex);
            }
        }
        return transformer.apply(dataBuffer, headersBuffer);
    }

    public ServiceMessage decode(ByteBuf dataBuffer, ByteBuf headersBuffer) throws MessageCodecException {
        ServiceMessage.Builder builder = ServiceMessage.builder();
        if (dataBuffer.isReadable()) {
            builder.data((Object)dataBuffer);
        }
        if (headersBuffer.isReadable()) {
            try (ByteBufInputStream stream = new ByteBufInputStream(headersBuffer.slice());){
                builder.headers(this.headersCodec.decode((InputStream)stream));
            }
            catch (Throwable ex) {
                LOGGER.error("Failed to decode message headers: {}, cause: {}", (Object)headersBuffer.toString(StandardCharsets.UTF_8), (Object)ex);
                throw new MessageCodecException("Failed to decode message headers", ex);
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)headersBuffer);
            }
        }
        return builder.build();
    }

    public static ServiceMessage decodeData(ServiceMessage message, Class<?> dataType) throws MessageCodecException {
        Object data;
        if (!message.hasData(ByteBuf.class) || dataType == null) {
            return message;
        }
        Class targetType = ExceptionProcessor.isError((ServiceMessage)message) ? ErrorData.class : dataType;
        ByteBuf dataBuffer = (ByteBuf)message.data();
        try (ByteBufInputStream inputStream = new ByteBufInputStream(dataBuffer.slice());){
            String contentType = Optional.ofNullable(message.dataFormat()).orElse(DEFAULT_DATA_FORMAT);
            DataCodec dataCodec = DataCodec.getInstance(contentType);
            data = dataCodec.decode((InputStream)inputStream, targetType);
        }
        catch (Throwable ex) {
            LOGGER.error("Failed to decode data on: {}, cause: {}, data buffer: {}", new Object[]{message, ex, dataBuffer.toString(StandardCharsets.UTF_8)});
            throw new MessageCodecException("Failed to decode data on message q=" + message.qualifier(), ex);
        }
        finally {
            ReferenceCountUtil.safeRelease((Object)dataBuffer);
        }
        if (targetType == ErrorData.class) {
            throw ExceptionProcessor.toException((String)message.qualifier(), (ErrorData)((ErrorData)data));
        }
        return ServiceMessage.from((ServiceMessage)message).data(data).build();
    }
}

