/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.codec;

import io.scalecube.services.ServiceLoaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public interface DataCodec {
    public static final Map<String, DataCodec> INSTANCES = new ConcurrentHashMap<String, DataCodec>();

    public static DataCodec getInstance(String contentType) {
        return INSTANCES.computeIfAbsent(contentType, DataCodec::loadInstance);
    }

    public static DataCodec loadInstance(String contentType) {
        Optional result = ServiceLoaderUtil.findFirst(DataCodec.class, codec -> codec.contentType().equalsIgnoreCase(contentType));
        return (DataCodec)result.orElseThrow(() -> new IllegalStateException("DataCodec not configured"));
    }

    public String contentType();

    public void encode(OutputStream var1, Object var2) throws IOException;

    public Object decode(InputStream var1, Class<?> var2) throws IOException;
}

