/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.util.ReferenceCountUtil;
import io.scalecube.services.api.ErrorData;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.codec.DataCodec;
import io.scalecube.services.exceptions.BadRequestException;
import io.scalecube.services.exceptions.ExceptionProcessor;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceMessageDataCodec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceMessageDataCodec.class);
    private static final String DEFAULT_DATA_FORMAT = "application/json";

    public ServiceMessage encode(ServiceMessage message) {
        if (message.hasData(ByteBuf.class)) {
            return message;
        }
        if (message.hasData()) {
            ByteBuf buffer = ByteBufAllocator.DEFAULT.buffer();
            try {
                String contentType = Optional.ofNullable(message.dataFormat()).orElse(DEFAULT_DATA_FORMAT);
                DataCodec dataCodec = DataCodec.getInstance(contentType);
                dataCodec.encode((OutputStream)new ByteBufOutputStream(buffer), message.data());
                return ServiceMessage.from((ServiceMessage)message).data((Object)buffer).build();
            }
            catch (Throwable ex) {
                ReferenceCountUtil.release((Object)buffer);
                LOGGER.error("Failed to encode data on: {}, cause: {}", (Object)message, (Object)ex);
                throw new BadRequestException("Failed to encode data on message q=" + message.qualifier());
            }
        }
        return message;
    }

    public ServiceMessage decode(ServiceMessage message, Class<?> type) {
        Object data;
        if (!message.hasData(ByteBuf.class) || type == null) {
            return message;
        }
        Class targetType = ExceptionProcessor.isError((ServiceMessage)message) ? ErrorData.class : type;
        ByteBuf dataBuffer = (ByteBuf)message.data();
        try (ByteBufInputStream inputStream = new ByteBufInputStream(dataBuffer.slice());){
            String contentType = Optional.ofNullable(message.dataFormat()).orElse(DEFAULT_DATA_FORMAT);
            DataCodec dataCodec = DataCodec.getInstance(contentType);
            data = dataCodec.decode((InputStream)inputStream, targetType);
        }
        catch (Throwable ex) {
            LOGGER.error("Failed to decode data on: {}, cause: {}, data buffer: {}", new Object[]{message, ex, dataBuffer.toString(Charset.defaultCharset())});
            throw new BadRequestException("Failed to decode data on message q=" + message.qualifier());
        }
        finally {
            ReferenceCountUtil.release((Object)dataBuffer);
        }
        if (targetType == ErrorData.class) {
            throw ExceptionProcessor.toException((String)message.qualifier(), (ErrorData)((ErrorData)data));
        }
        return ServiceMessage.from((ServiceMessage)message).data(data).build();
    }
}

