/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.benchmarks.transport;

import io.scalecube.benchmarks.BenchmarkSettings;
import io.scalecube.benchmarks.BenchmarkState;
import io.scalecube.net.Address;
import io.scalecube.services.Microservices;
import io.scalecube.services.ServiceCall;
import io.scalecube.services.benchmarks.ServiceTransports;
import io.scalecube.services.discovery.ScalecubeServiceDiscovery;
import java.time.Duration;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class BenchmarkServiceState
extends BenchmarkState<BenchmarkServiceState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BenchmarkServiceState.class);
    private static final Duration SHUTDOWN_TIMEOUT = Duration.ofSeconds(6L);
    private final Object[] services;
    private Microservices seed;
    private Microservices node;

    public BenchmarkServiceState(BenchmarkSettings settings, Object ... services) {
        super(settings);
        this.services = services;
    }

    public void beforeAll() {
        this.seed = Microservices.builder().metrics(this.registry()).discovery(ScalecubeServiceDiscovery::new).transport(ServiceTransports::rsocketServiceTransport).startAwait();
        Address seedAddress = this.seed.discovery().address();
        this.node = Microservices.builder().metrics(this.registry()).discovery(serviceEndpoint -> new ScalecubeServiceDiscovery(serviceEndpoint).options(opts -> opts.seedMembers(new Address[]{seedAddress}))).transport(ServiceTransports::rsocketServiceTransport).services(this.services).startAwait();
        LOGGER.info("Seed address: " + this.seed.discovery().address() + ", services address: " + this.node.serviceAddress());
    }

    public void afterAll() {
        try {
            Mono.when((Publisher[])new Publisher[]{this.node.shutdown(), this.seed.shutdown()}).block(SHUTDOWN_TIMEOUT);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Microservices seed() {
        return this.seed;
    }

    public <T> T api(Class<T> c) {
        return (T)this.call().api(c);
    }

    public ServiceCall call() {
        return this.seed.call();
    }
}

