/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.benchmarks.gateway.distributed;

import io.scalecube.benchmarks.BenchmarkSettings;
import io.scalecube.services.Microservices;
import io.scalecube.services.benchmarks.ServiceTransports;
import io.scalecube.services.benchmarks.gateway.AbstractBenchmarkState;
import io.scalecube.services.discovery.ClusterAddresses;
import io.scalecube.services.discovery.ScalecubeServiceDiscovery;
import io.scalecube.services.examples.BenchmarkServiceImpl;
import io.scalecube.services.gateway.clientsdk.Client;
import io.scalecube.services.gateway.http.HttpGateway;
import io.scalecube.services.gateway.rsocket.RSocketGateway;
import io.scalecube.services.gateway.ws.WebsocketGateway;
import io.scalecube.services.transport.api.Address;
import java.util.function.BiFunction;
import reactor.core.publisher.Mono;
import reactor.netty.resources.LoopResources;

public class DistributedBenchmarkState
extends AbstractBenchmarkState<DistributedBenchmarkState> {
    private final String gatewayName;
    private Microservices services;
    private Microservices gateway;

    public DistributedBenchmarkState(BenchmarkSettings settings, String gatewayName, BiFunction<Address, LoopResources, Client> clientBuilder) {
        super(settings, clientBuilder);
        this.gatewayName = gatewayName;
    }

    @Override
    protected void beforeAll() throws Exception {
        super.beforeAll();
        this.gateway = Microservices.builder().gateway(opts -> new RSocketGateway(opts.id("rsws"))).gateway(opts -> new WebsocketGateway(opts.id("ws"))).gateway(opts -> new HttpGateway(opts.id("http"))).discovery(ScalecubeServiceDiscovery::new).transport(ServiceTransports::rsocketServiceTransport).metrics(this.registry()).startAwait();
        io.scalecube.transport.Address seedAddress = ClusterAddresses.toAddress((Address)this.gateway.discovery().address());
        int numOfThreads = Runtime.getRuntime().availableProcessors();
        this.services = Microservices.builder().discovery(serviceEndpoint -> new ScalecubeServiceDiscovery(serviceEndpoint).options(opts -> opts.seedMembers(new io.scalecube.transport.Address[]{seedAddress}))).transport(opts -> ServiceTransports.rsocketServiceTransport(opts, numOfThreads)).services(new Object[]{new BenchmarkServiceImpl()}).startAwait();
    }

    @Override
    protected void afterAll() throws Exception {
        super.afterAll();
        if (this.services != null) {
            this.services.shutdown().block();
        }
        if (this.gateway != null) {
            this.gateway.shutdown().block();
        }
    }

    @Override
    public Mono<Client> createClient() {
        return this.createClient(this.gateway, this.gatewayName, this.clientBuilder);
    }
}

