/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.benchmarks.gateway.codec;

import io.netty.buffer.ByteBuf;
import io.scalecube.benchmarks.BenchmarkSettings;
import io.scalecube.benchmarks.metrics.BenchmarkMeter;
import io.scalecube.benchmarks.metrics.BenchmarkTimer;
import io.scalecube.services.benchmarks.gateway.codec.GwMessageCodecBenchmarkState;
import io.scalecube.services.gateway.ws.GatewayMessage;
import io.scalecube.services.gateway.ws.GatewayMessageCodec;
import java.util.concurrent.TimeUnit;

public class GwMessageEncoderBenchmark {
    public static void main(String[] args) {
        BenchmarkSettings settings = BenchmarkSettings.from((String[])args).durationUnit(TimeUnit.NANOSECONDS).build();
        new GwMessageCodecBenchmarkState(settings).runForSync(state -> {
            GatewayMessageCodec codec = state.codec();
            GatewayMessage message = state.message();
            BenchmarkTimer timer = state.timer("timer");
            BenchmarkMeter meter = state.meter("meter");
            return i -> {
                BenchmarkTimer.Context timerContext = timer.time();
                ByteBuf bb = codec.encode(message);
                timerContext.stop();
                meter.mark();
                bb.release();
                return bb;
            };
        });
    }
}

