/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.benchmarks.gateway;

import io.scalecube.benchmarks.BenchmarkSettings;
import io.scalecube.benchmarks.BenchmarkState;
import io.scalecube.benchmarks.metrics.BenchmarkMeter;
import io.scalecube.services.benchmarks.LatencyHelper;
import io.scalecube.services.benchmarks.gateway.AbstractBenchmarkState;
import io.scalecube.services.gateway.clientsdk.ClientMessage;
import io.scalecube.services.gateway.clientsdk.ReferenceCountUtil;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public final class RequestOneScenario {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestOneScenario.class);
    private static final String QUALIFIER = "/benchmarks/one";

    private RequestOneScenario() {
    }

    public static void runWith(String[] args, Function<BenchmarkSettings, AbstractBenchmarkState<?>> benchmarkStateFactory) {
        BenchmarkSettings settings = BenchmarkSettings.from((String[])args).build();
        AbstractBenchmarkState<?> benchmarkState = benchmarkStateFactory.apply(settings);
        benchmarkState.runForAsync(state -> {
            LatencyHelper latencyHelper = new LatencyHelper((BenchmarkState)state);
            BenchmarkMeter clientToServiceMeter = state.meter("meter.client-to-service");
            BenchmarkMeter serviceToClientMeter = state.meter("meter.service-to-client");
            ThreadLocal<Mono> clientHolder = ThreadLocal.withInitial(() -> state.createClient().cache());
            return i -> {
                Mono clientMono = (Mono)clientHolder.get();
                return clientMono.flatMap(client -> {
                    clientToServiceMeter.mark();
                    return client.requestResponse(RequestOneScenario.enrichRequest()).map(RequestOneScenario::enrichResponse).doOnNext(msg -> {
                        serviceToClientMeter.mark();
                        Optional.ofNullable(msg.data()).ifPresent(ReferenceCountUtil::safestRelease);
                        latencyHelper.calculate((ClientMessage)msg);
                    }).doOnError(th -> LOGGER.warn("Exception occured on requestResponse: " + th));
                });
            };
        });
    }

    private static ClientMessage enrichResponse(ClientMessage msg) {
        return ClientMessage.from((ClientMessage)msg).header("client-recv-time", (Object)System.currentTimeMillis()).build();
    }

    private static ClientMessage enrichRequest() {
        return ClientMessage.builder().qualifier(QUALIFIER).header("client-send-time", (Object)System.currentTimeMillis()).build();
    }
}

