/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.benchmarks.service;

import io.scalecube.benchmarks.BenchmarkSettings;
import io.scalecube.benchmarks.BenchmarkState;
import io.scalecube.services.Microservices;
import io.scalecube.services.ServiceCall;
import io.scalecube.services.api.Address;
import java.time.Duration;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class BenchmarkServiceState
extends BenchmarkState<BenchmarkServiceState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BenchmarkServiceState.class);
    private static final Duration SHUTDOWN_TIMEOUT = Duration.ofSeconds(6L);
    private final Object[] services;
    private Microservices seed;
    private Microservices node;

    public BenchmarkServiceState(BenchmarkSettings settings, Object ... services) {
        super(settings);
        this.services = services;
    }

    public void beforeAll() {
        this.seed = Microservices.builder().metrics(this.registry()).startAwait();
        this.node = Microservices.builder().metrics(this.registry()).discovery(options -> options.seeds(new Address[]{this.seed.discovery().address()})).services(this.services).startAwait();
        LOGGER.info("Seed address: " + this.seed.discovery().address() + ", services address: " + this.node.serviceAddress());
    }

    public void afterAll() {
        try {
            Mono.when((Publisher[])new Publisher[]{this.node.shutdown(), this.seed.shutdown()}).block(SHUTDOWN_TIMEOUT);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Microservices seed() {
        return this.seed;
    }

    public <T> T service(Class<T> c) {
        return (T)this.seed.call().create().api(c);
    }

    public ServiceCall serviceCall() {
        return this.seed.call().create();
    }
}

