/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.benchmarks.transport.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.Payload;
import io.rsocket.util.ByteBufPayload;
import io.scalecube.benchmarks.BenchmarkSettings;
import io.scalecube.benchmarks.BenchmarkState;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.transport.api.DataCodec;
import io.scalecube.services.transport.api.HeadersCodec;
import io.scalecube.services.transport.api.ServiceMessageCodec;
import io.scalecube.services.transport.jackson.JacksonCodec;
import io.scalecube.services.transport.protostuff.ProtostuffCodec;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.UUID;

public class SmCodecBenchmarkState
extends BenchmarkState<SmCodecBenchmarkState> {
    private ServiceMessageCodec serviceMessageCodec;
    private HeadersCodec headersCodec;
    private DataCodec dataCodec;
    private ServiceMessage serviceMessage;
    private Payload payloadMessage;

    public SmCodecBenchmarkState(BenchmarkSettings settings, DataCodec dataCodec, HeadersCodec headersCodec) {
        super(settings);
        this.dataCodec = dataCodec;
        this.headersCodec = headersCodec;
    }

    protected void beforeAll() {
        this.serviceMessageCodec = new ServiceMessageCodec(this.headersCodec, Collections.singletonList(this.dataCodec));
        this.serviceMessage = this.generateServiceMessage(this.generateData());
        this.payloadMessage = this.generatePayload(this.serviceMessage);
    }

    public ServiceMessageCodec messageCodec() {
        return this.serviceMessageCodec;
    }

    public ByteBuf dataBuffer() {
        return this.payloadMessage.sliceData();
    }

    public ByteBuf headersBuffer() {
        return this.payloadMessage.sliceMetadata();
    }

    public Class<?> dataType() {
        return PlaceOrderRequest.class;
    }

    public ServiceMessage message() {
        return this.serviceMessage;
    }

    public ServiceMessage messageWithByteBuf() {
        return ServiceMessage.from((ServiceMessage)this.serviceMessage).data((Object)this.payloadMessage.sliceData()).build();
    }

    private PlaceOrderRequest generateData() {
        PlaceOrderRequest result = new PlaceOrderRequest();
        result.orderType = "Sell";
        result.side = "Sell";
        result.instanceId = UUID.randomUUID().toString();
        result.quantity = BigDecimal.valueOf(Long.MAX_VALUE);
        result.price = BigDecimal.valueOf(Long.MAX_VALUE);
        result.isClosePositionOrder = false;
        result.requestTimestamp = LocalDateTime.now();
        result.sourceIpAddress = "255.255.255.255";
        result.token = "eyJhbGciOiJIUzI1NiJ9.eyJhdWQiOiJUZW5hbnQxIiwic3ViIjoiMSIsIm5hbWUiOiJ0cmFkZXIxIn0.j9dCs63J4xtWfhctrXb5popLAl8ohSlMTJU3_vCrQHk";
        return result;
    }

    private ServiceMessage generateServiceMessage(Object data) {
        return ServiceMessage.builder().dataFormat(this.dataCodec.contentType()).qualifier("io.scalecube.services.benchmarks/SomeBenchmarkService/benchmark").header("sid", String.valueOf(Integer.MAX_VALUE)).header("sig", String.valueOf(9)).header("inactivity", String.valueOf(Integer.MAX_VALUE)).data(data).build();
    }

    private Payload generatePayload(ServiceMessage msg) {
        try {
            ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
            this.dataCodec.encode((OutputStream)dataStream, msg.data());
            System.out.println("generated dataBuffer: " + dataStream.toString());
            ByteBuf dataBuffer = ByteBufAllocator.DEFAULT.buffer();
            dataBuffer.writeBytes(dataStream.toByteArray());
            ByteArrayOutputStream headersStream = new ByteArrayOutputStream();
            this.headersCodec.encode((OutputStream)headersStream, msg.headers());
            System.out.println("generated headersBuffer: " + headersStream.toString());
            ByteBuf headersBuffer = ByteBufAllocator.DEFAULT.buffer();
            headersBuffer.writeBytes(headersStream.toByteArray());
            return ByteBufPayload.create((ByteBuf)dataBuffer, (ByteBuf)headersBuffer);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    public static class Protostuff
    extends SmCodecBenchmarkState {
        private static final ProtostuffCodec CODEC = new ProtostuffCodec();

        public Protostuff(BenchmarkSettings settings) {
            super(settings, (DataCodec)CODEC, (HeadersCodec)CODEC);
        }
    }

    public static class Jackson
    extends SmCodecBenchmarkState {
        private static final JacksonCodec CODEC = new JacksonCodec();

        public Jackson(BenchmarkSettings settings) {
            super(settings, (DataCodec)CODEC, (HeadersCodec)CODEC);
        }
    }

    public static class PlaceOrderRequest {
        private String orderType;
        private String side;
        private String instanceId;
        private BigDecimal quantity;
        private BigDecimal price;
        private boolean isClosePositionOrder;
        private LocalDateTime requestTimestamp;
        private String token;
        private String sourceIpAddress;

        PlaceOrderRequest() {
        }

        public String toString() {
            return "PlaceOrderRequest{token='" + this.token + '\'' + ", sourceIpAddress='" + this.sourceIpAddress + '\'' + ", orderType='" + this.orderType + '\'' + ", side='" + this.side + '\'' + ", side='" + this.side + '\'' + ", instanceId='" + this.instanceId + '\'' + ", quantity=" + this.quantity + ", price=" + this.price + ", isClosePositionOrder=" + this.isClosePositionOrder + ", requestTimestamp=" + this.requestTimestamp + '}';
        }
    }
}

