/*
 * Decompiled with CFR 0.152.
 */
package reactor.retry;

import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.retry.Backoff;
import reactor.retry.DefaultRetry;
import reactor.retry.Jitter;
import reactor.retry.RetryContext;

public interface Retry<T>
extends Function<Flux<Throwable>, Publisher<Long>> {
    public static <T> Retry<T> any() {
        return DefaultRetry.create(context -> true);
    }

    @SafeVarargs
    public static <T> Retry<T> anyOf(Class<? extends Throwable> ... retriableExceptions) {
        Predicate<RetryContext> predicate = context -> {
            Throwable exception = context.exception();
            if (exception == null) {
                return true;
            }
            for (Class clazz : retriableExceptions) {
                if (!clazz.isInstance(exception)) continue;
                return true;
            }
            return false;
        };
        return DefaultRetry.create(predicate);
    }

    @SafeVarargs
    public static <T> Retry<T> allBut(Class<? extends Throwable> ... nonRetriableExceptions) {
        Predicate<RetryContext> predicate = context -> {
            Throwable exception = context.exception();
            if (exception == null) {
                return true;
            }
            for (Class clazz : nonRetriableExceptions) {
                if (!clazz.isInstance(exception)) continue;
                return false;
            }
            return true;
        };
        return DefaultRetry.create(predicate);
    }

    public static <T> Retry<T> onlyIf(Predicate<? super RetryContext<T>> predicate) {
        return DefaultRetry.create(predicate).retryMax(Integer.MAX_VALUE);
    }

    public Retry<T> withApplicationContext(T var1);

    public Retry<T> doOnRetry(Consumer<? super RetryContext<T>> var1);

    default public Retry<T> retryOnce() {
        return this.retryMax(1);
    }

    public Retry<T> retryMax(int var1);

    public Retry<T> timeout(Duration var1);

    public Retry<T> backoff(Backoff var1);

    public Retry<T> jitter(Jitter var1);

    public Retry<T> withBackoffScheduler(Scheduler var1);

    default public Retry<T> noBackoff() {
        return this.backoff(Backoff.zero());
    }

    default public Retry<T> fixedBackoff(Duration backoffInterval) {
        return this.backoff(Backoff.fixed(backoffInterval));
    }

    default public Retry<T> exponentialBackoff(Duration firstBackoff, Duration maxBackoff) {
        return this.backoff(Backoff.exponential(firstBackoff, maxBackoff, 2, false));
    }

    default public Retry<T> exponentialBackoffWithJitter(Duration firstBackoff, Duration maxBackoff) {
        return this.backoff(Backoff.exponential(firstBackoff, maxBackoff, 2, false)).jitter(Jitter.random());
    }

    default public Retry<T> randomBackoff(Duration firstBackoff, Duration maxBackoff) {
        return this.backoff(Backoff.exponential(firstBackoff, maxBackoff, 3, true)).jitter(Jitter.random());
    }

    @Override
    default public <S> Flux<S> apply(Publisher<S> source) {
        return Flux.from(source).retryWhen(this);
    }
}

