/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.resources;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.pool.SimpleChannelPool;
import java.net.SocketAddress;
import java.util.function.Consumer;
import java.util.function.Supplier;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.resources.DefaultPoolResources;

@FunctionalInterface
public interface PoolResources
extends Disposable {
    public static final int DEFAULT_POOL_MAX_CONNECTION = Integer.parseInt(System.getProperty("reactor.ipc.netty.pool.maxConnections", "" + Math.max(Runtime.getRuntime().availableProcessors(), 8) * 2));
    public static final long DEFAULT_POOL_ACQUIRE_TIMEOUT = Long.parseLong(System.getProperty("reactor.ipc.netty.pool.acquireTimeout", "45000"));

    public static PoolResources elastic(String name) {
        return new DefaultPoolResources(name, SimpleChannelPool::new);
    }

    public static PoolResources fixed(String name) {
        return PoolResources.fixed(name, DEFAULT_POOL_MAX_CONNECTION);
    }

    public static PoolResources fixed(String name, int maxConnections) {
        return PoolResources.fixed(name, maxConnections, DEFAULT_POOL_ACQUIRE_TIMEOUT);
    }

    public static PoolResources fixed(String name, int maxConnections, long acquireTimeout) {
        if (maxConnections == -1) {
            return PoolResources.elastic(name);
        }
        if (maxConnections <= 0) {
            throw new IllegalArgumentException("Max Connections value must be strictly positive");
        }
        if (acquireTimeout != -1L && acquireTimeout < 0L) {
            throw new IllegalArgumentException("Acquire Timeout value must be positive");
        }
        return new DefaultPoolResources(name, (bootstrap, handler, checker) -> new FixedChannelPool(bootstrap, handler, checker, FixedChannelPool.AcquireTimeoutAction.FAIL, acquireTimeout, maxConnections, Integer.MAX_VALUE));
    }

    public ChannelPool selectOrCreate(SocketAddress var1, Supplier<? extends Bootstrap> var2, Consumer<? super Channel> var3, EventLoopGroup var4);

    @Override
    default public void dispose() {
        this.disposeLater().subscribe();
    }

    default public Mono<Void> disposeLater() {
        return Mono.empty();
    }
}

