/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.NettyConnector;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.channel.ContextHandler;
import reactor.ipc.netty.http.HttpResources;
import reactor.ipc.netty.http.server.HttpServerHandler;
import reactor.ipc.netty.http.server.HttpServerOperations;
import reactor.ipc.netty.http.server.HttpServerOptions;
import reactor.ipc.netty.http.server.HttpServerRequest;
import reactor.ipc.netty.http.server.HttpServerResponse;
import reactor.ipc.netty.http.server.HttpServerRoutes;
import reactor.ipc.netty.options.ServerOptions;
import reactor.ipc.netty.tcp.BlockingNettyContext;
import reactor.ipc.netty.tcp.TcpServer;

public final class HttpServer
implements NettyConnector<HttpServerRequest, HttpServerResponse> {
    private final TcpBridgeServer server;
    final HttpServerOptions options;
    static final LoggingHandler loggingHandler = new LoggingHandler(HttpServer.class);

    public static HttpServer create() {
        return HttpServer.builder().build();
    }

    public static HttpServer create(Consumer<? super HttpServerOptions.Builder> options) {
        return HttpServer.builder().options(options).build();
    }

    public static HttpServer create(int port) {
        return HttpServer.builder().listenAddress(new InetSocketAddress(port)).build();
    }

    public static HttpServer create(String bindAddress) {
        return HttpServer.builder().bindAddress(bindAddress).build();
    }

    public static HttpServer create(String bindAddress, int port) {
        return HttpServer.builder().bindAddress(bindAddress).port(port).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private HttpServer(Builder builder) {
        HttpServerOptions.Builder serverOptionsBuilder = HttpServerOptions.builder();
        if (Objects.isNull(builder.options)) {
            if (Objects.isNull(builder.bindAddress)) {
                serverOptionsBuilder.listenAddress((SocketAddress)builder.listenAddress.get());
            } else {
                ((HttpServerOptions.Builder)serverOptionsBuilder.host(builder.bindAddress)).port(builder.port);
            }
        } else {
            builder.options.accept(serverOptionsBuilder);
        }
        if (!serverOptionsBuilder.isLoopAvailable()) {
            serverOptionsBuilder.loopResources(HttpResources.get());
        }
        this.options = serverOptionsBuilder.build();
        this.server = new TcpBridgeServer(this.options);
    }

    public final HttpServerOptions options() {
        return this.options.duplicate();
    }

    public String toString() {
        return "HttpServer: " + this.options.asSimpleString();
    }

    @Override
    public Mono<? extends NettyContext> newHandler(BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.server.newHandler((BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>>)handler);
    }

    public Mono<? extends NettyContext> newRouter(Consumer<? super HttpServerRoutes> routesBuilder) {
        Objects.requireNonNull(routesBuilder, "routeBuilder");
        HttpServerRoutes routes = HttpServerRoutes.newRoutes();
        routesBuilder.accept(routes);
        return this.newHandler(routes);
    }

    public BlockingNettyContext startRouter(Consumer<? super HttpServerRoutes> routesBuilder) {
        Objects.requireNonNull(routesBuilder, "routeBuilder");
        HttpServerRoutes routes = HttpServerRoutes.newRoutes();
        routesBuilder.accept(routes);
        return this.start(routes);
    }

    public void startRouterAndAwait(Consumer<? super HttpServerRoutes> routesBuilder) {
        this.startRouterAndAwait(routesBuilder, null);
    }

    public void startRouterAndAwait(Consumer<? super HttpServerRoutes> routesBuilder, Consumer<BlockingNettyContext> onStart) {
        Objects.requireNonNull(routesBuilder, "routeBuilder");
        HttpServerRoutes routes = HttpServerRoutes.newRoutes();
        routesBuilder.accept(routes);
        this.startAndAwait(routes, onStart);
    }

    static BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate(HttpServerOptions options) {
        int minResponseSize = options.minCompressionResponseSize();
        if (minResponseSize < 0) {
            return null;
        }
        if (minResponseSize == 0) {
            return options.compressionPredicate();
        }
        BiPredicate<HttpServerRequest, HttpServerResponse> lengthPredicate = (req, res) -> {
            String length = res.responseHeaders().get(HttpHeaderNames.CONTENT_LENGTH);
            if (length == null) {
                return true;
            }
            try {
                return Long.parseLong(length) >= (long)minResponseSize;
            }
            catch (NumberFormatException nfe) {
                return true;
            }
        };
        if (options.compressionPredicate() == null) {
            return lengthPredicate;
        }
        return lengthPredicate.and(options.compressionPredicate());
    }

    public static final class Builder {
        private String bindAddress = null;
        private int port = 8080;
        private Supplier<InetSocketAddress> listenAddress = () -> new InetSocketAddress(NetUtil.LOCALHOST, this.port);
        private Consumer<? super HttpServerOptions.Builder> options;

        private Builder() {
        }

        public final Builder bindAddress(String bindAddress) {
            this.bindAddress = Objects.requireNonNull(bindAddress, "bindAddress");
            return this;
        }

        public final Builder listenAddress(InetSocketAddress listenAddress) {
            Objects.requireNonNull(listenAddress, "listenAddress");
            this.listenAddress = () -> listenAddress;
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            return this;
        }

        public final Builder options(Consumer<? super HttpServerOptions.Builder> options) {
            this.options = Objects.requireNonNull(options, "options");
            return this;
        }

        public HttpServer build() {
            return new HttpServer(this);
        }
    }

    final class TcpBridgeServer
    extends TcpServer
    implements BiConsumer<ChannelPipeline, ContextHandler<Channel>> {
        TcpBridgeServer(ServerOptions options) {
            super(options);
        }

        @Override
        protected ContextHandler<Channel> doHandler(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler, MonoSink<NettyContext> sink) {
            BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate = HttpServer.compressPredicate(HttpServer.this.options);
            boolean alwaysCompress = compressPredicate == null && HttpServer.this.options.minCompressionResponseSize() == 0;
            return ContextHandler.newServerContext(sink, HttpServer.this.options, loggingHandler, (ch, c, msg) -> {
                HttpServerOperations ops = HttpServerOperations.bindHttp(ch, handler, c, compressPredicate, msg);
                if (alwaysCompress) {
                    ops.compression(true);
                }
                return ops;
            }).onPipeline(this).autoCreateOperations(false);
        }

        @Override
        public void accept(ChannelPipeline p, ContextHandler<Channel> c) {
            p.addLast("reactor.left.httpCodec", (ChannelHandler)new HttpServerCodec(HttpServer.this.options.httpCodecMaxInitialLineLength(), HttpServer.this.options.httpCodecMaxHeaderSize(), HttpServer.this.options.httpCodecMaxChunkSize(), HttpServer.this.options.httpCodecValidateHeaders(), HttpServer.this.options.httpCodecInitialBufferSize()));
            p.addLast("reactor.left.httpServerHandler", (ChannelHandler)new HttpServerHandler(c));
        }

        @Override
        protected LoggingHandler loggingHandler() {
            return loggingHandler;
        }
    }
}

