/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.proxy.ProxyHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.channel.AbortedException;
import reactor.ipc.netty.channel.ChannelOperations;
import reactor.ipc.netty.channel.CloseableContextHandler;
import reactor.ipc.netty.options.ClientOptions;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

final class ClientContextHandler<CHANNEL extends Channel>
extends CloseableContextHandler<CHANNEL> {
    final ClientOptions clientOptions;
    final boolean secure;

    ClientContextHandler(ChannelOperations.OnNew<CHANNEL> channelOpFactory, ClientOptions options, MonoSink<NettyContext> sink, LoggingHandler loggingHandler, boolean secure, SocketAddress providedAddress) {
        super(channelOpFactory, options, sink, loggingHandler, providedAddress);
        this.clientOptions = options;
        this.secure = secure;
    }

    @Override
    public final void fireContextActive(NettyContext context) {
        if (!this.fired) {
            this.fired = true;
            if (context != null) {
                this.sink.success(context);
            } else {
                this.sink.success();
            }
        }
    }

    @Override
    protected void doDropped(Channel channel) {
        channel.close();
        if (!this.fired) {
            this.fired = true;
            this.sink.error(new AbortedException("Channel has been dropped"));
        }
    }

    @Override
    protected Tuple2<String, Integer> getSNI() {
        if (this.providedAddress instanceof InetSocketAddress) {
            InetSocketAddress ipa = (InetSocketAddress)this.providedAddress;
            return Tuples.of(ipa.getHostString(), ipa.getPort());
        }
        return null;
    }

    @Override
    protected void doPipeline(Channel ch) {
        ClientContextHandler.addSslAndLogHandlers(this.clientOptions, this, this.loggingHandler, this.secure, this.getSNI(), ch.pipeline());
        ClientContextHandler.addProxyHandler(this.clientOptions, ch.pipeline(), this.providedAddress);
    }

    static void addProxyHandler(ClientOptions clientOptions, ChannelPipeline pipeline, SocketAddress providedAddress) {
        ProxyHandler proxy;
        ProxyHandler proxyHandler = proxy = clientOptions.useProxy(providedAddress) ? clientOptions.getProxyOptions().newProxyHandler() : null;
        if (proxy != null) {
            pipeline.addFirst("reactor.left.proxyHandler", (ChannelHandler)proxy);
            if (log.isDebugEnabled()) {
                pipeline.addFirst(new LoggingHandler("reactor.ipc.netty.proxy"));
            }
        }
    }
}

