/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

public abstract class FutureMono
extends Mono<Void> {
    public static <F extends Future<Void>> Mono<Void> from(F future) {
        if (future.isDone()) {
            if (!future.isSuccess()) {
                return Mono.error(future.cause());
            }
            return Mono.empty();
        }
        return new ImmediateFutureMono<F>(future);
    }

    public static <F extends Future<Void>> Mono<Void> deferFuture(Supplier<F> deferredFuture) {
        return new DeferredFutureMono<F>(deferredFuture);
    }

    public static Mono<Void> disposableWriteAndFlush(Channel channel, Publisher<?> dataStream) {
        return new DeferredWriteMono(channel, dataStream);
    }

    public static <F extends Future<Void>> Mono<Void> deferFutureWithContext(Function<Context, F> deferredFuture) {
        return new DeferredContextFutureMono<F>(deferredFuture);
    }

    static <T> Publisher<T> wrapContextAndDispose(Publisher<T> publisher, final ChannelFutureSubscription cfs) {
        if (publisher instanceof Callable) {
            return publisher;
        }
        if (publisher instanceof Flux) {
            return new FluxOperator<T, T>((Flux)publisher){

                @Override
                public void subscribe(CoreSubscriber<? super T> actual) {
                    cfs.ioActual = actual;
                    this.source.subscribe(actual);
                }
            };
        }
        if (publisher instanceof Mono) {
            return new MonoOperator<T, T>((Mono)publisher){

                @Override
                public void subscribe(CoreSubscriber<? super T> actual) {
                    cfs.ioActual = actual;
                    this.source.subscribe(actual);
                }
            };
        }
        return publisher;
    }

    static final class ChannelFutureSubscription
    extends DefaultChannelPromise
    implements Subscription,
    Function<Void, Context> {
        final CoreSubscriber<? super Void> actual;
        CoreSubscriber<?> ioActual;

        ChannelFutureSubscription(Channel channel, CoreSubscriber<? super Void> actual) {
            super(channel, channel.eventLoop());
            this.actual = actual;
        }

        @Override
        public void request(long n) {
        }

        @Override
        public Context apply(Void aVoid) {
            return this.actual.currentContext();
        }

        @Override
        public void cancel() {
            if (!this.executor().inEventLoop()) {
                this.executor().execute(this::cancel);
                return;
            }
            CoreSubscriber<?> ioActual = this.ioActual;
            this.ioActual = null;
            if (ioActual instanceof Consumer) {
                ((Consumer)((Object)ioActual)).accept(this);
            }
        }

        @Override
        public boolean trySuccess(Void result) {
            this.ioActual = null;
            boolean r = super.trySuccess(result);
            this.actual.onComplete();
            return r;
        }

        @Override
        public ChannelPromise setSuccess(Void result) {
            this.ioActual = null;
            super.setSuccess(result);
            this.actual.onComplete();
            return this;
        }

        @Override
        public boolean tryFailure(Throwable cause) {
            this.ioActual = null;
            boolean r = super.tryFailure(cause);
            this.actual.onError(cause);
            return r;
        }

        @Override
        public ChannelPromise setFailure(Throwable cause) {
            this.ioActual = null;
            super.setFailure(cause);
            this.actual.onError(cause);
            return this;
        }
    }

    static final class DeferredWriteMono
    extends FutureMono {
        final Channel channel;
        final Publisher<?> dataStream;

        DeferredWriteMono(Channel channel, Publisher<?> dataStream) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.dataStream = Objects.requireNonNull(dataStream, "dataStream");
        }

        @Override
        public void subscribe(CoreSubscriber<? super Void> s) {
            ChannelFutureSubscription cfs = new ChannelFutureSubscription(this.channel, s);
            s.onSubscribe(cfs);
            this.channel.writeAndFlush(DeferredWriteMono.wrapContextAndDispose(this.dataStream, cfs), cfs);
        }
    }

    static final class FutureSubscription<F extends Future<Void>>
    implements GenericFutureListener<F>,
    Subscription,
    Supplier<Context> {
        final CoreSubscriber<? super Void> s;
        final F future;

        FutureSubscription(F future, CoreSubscriber<? super Void> s) {
            this.s = s;
            this.future = future;
        }

        @Override
        public void request(long n) {
        }

        @Override
        public Context get() {
            return this.s.currentContext();
        }

        @Override
        public void cancel() {
            this.future.removeListener(this);
        }

        @Override
        public void operationComplete(F future) {
            if (!future.isSuccess()) {
                this.s.onError(future.cause());
            } else {
                this.s.onComplete();
            }
        }
    }

    static final class DeferredContextFutureMono<F extends Future<Void>>
    extends FutureMono {
        final Function<Context, F> deferredFuture;

        DeferredContextFutureMono(Function<Context, F> deferredFuture) {
            this.deferredFuture = Objects.requireNonNull(deferredFuture, "deferredFuture");
        }

        @Override
        public void subscribe(CoreSubscriber<? super Void> s) {
            Future f = (Future)this.deferredFuture.apply(s.currentContext());
            if (f == null) {
                Operators.error(s, Operators.onOperatorError(new NullPointerException("Deferred supplied null"), s.currentContext()));
                return;
            }
            if (f.isDone()) {
                if (f.isSuccess()) {
                    Operators.complete(s);
                } else {
                    Operators.error(s, f.cause());
                }
                return;
            }
            FutureSubscription<Future> fs = new FutureSubscription<Future>(f, s);
            s.onSubscribe(fs);
            f.addListener(fs);
        }
    }

    static final class DeferredFutureMono<F extends Future<Void>>
    extends FutureMono {
        final Supplier<F> deferredFuture;

        DeferredFutureMono(Supplier<F> deferredFuture) {
            this.deferredFuture = Objects.requireNonNull(deferredFuture, "deferredFuture");
        }

        @Override
        public void subscribe(CoreSubscriber<? super Void> s) {
            Future f = (Future)this.deferredFuture.get();
            if (f == null) {
                Operators.error(s, Operators.onOperatorError(new NullPointerException("Deferred supplied null"), s.currentContext()));
                return;
            }
            if (f.isDone()) {
                if (f.isSuccess()) {
                    Operators.complete(s);
                } else {
                    Operators.error(s, f.cause());
                }
                return;
            }
            FutureSubscription<Future> fs = new FutureSubscription<Future>(f, s);
            s.onSubscribe(fs);
            f.addListener(fs);
        }
    }

    static final class ImmediateFutureMono<F extends Future<Void>>
    extends FutureMono {
        final F future;

        ImmediateFutureMono(F future) {
            this.future = (Future)Objects.requireNonNull(future, "future");
        }

        @Override
        public final void subscribe(CoreSubscriber<? super Void> s) {
            if (this.future.isDone()) {
                if (this.future.isSuccess()) {
                    Operators.complete(s);
                } else {
                    Operators.error(s, this.future.cause());
                }
                return;
            }
            FutureSubscription<F> fs = new FutureSubscription<F>(this.future, s);
            this.future.addListener(fs);
            s.onSubscribe(fs);
        }
    }
}

