/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;

final class MonoLift<I, O>
extends MonoOperator<I, O> {
    final BiFunction<Scannable, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter;

    MonoLift(Publisher<I> p, BiFunction<Scannable, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter) {
        super(Mono.from(p));
        this.lifter = lifter;
    }

    @Override
    public void subscribe(CoreSubscriber<? super O> actual) {
        CoreSubscriber<? super I> input = this.lifter.apply(Scannable.from(this.source), actual);
        Objects.requireNonNull(input, "Lifted subscriber MUST NOT be null");
        this.source.subscribe(input);
    }
}

