/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.Iterator;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.filter.CompositeFilter;
import org.apache.logging.log4j.core.filter.Filterable;

public abstract class AbstractFilterable
extends AbstractLifeCycle
implements Filterable {
    private volatile Filter filter;

    protected AbstractFilterable(Filter filter) {
        this.filter = filter;
    }

    protected AbstractFilterable() {
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public synchronized void addFilter(Filter filter) {
        if (filter == null) {
            return;
        }
        if (this.filter == null) {
            this.filter = filter;
        } else if (this.filter instanceof CompositeFilter) {
            this.filter = ((CompositeFilter)this.filter).addFilter(filter);
        } else {
            Filter[] filters = new Filter[]{this.filter, filter};
            this.filter = CompositeFilter.createFilters(filters);
        }
    }

    @Override
    public synchronized void removeFilter(Filter filter) {
        if (this.filter == null || filter == null) {
            return;
        }
        if (this.filter == filter || this.filter.equals(filter)) {
            this.filter = null;
        } else if (this.filter instanceof CompositeFilter) {
            CompositeFilter composite = (CompositeFilter)this.filter;
            if ((composite = composite.removeFilter(filter)).size() > 1) {
                this.filter = composite;
            } else if (composite.size() == 1) {
                Iterator<Filter> iter2 = composite.iterator();
                this.filter = iter2.next();
            } else {
                this.filter = null;
            }
        }
    }

    @Override
    public boolean hasFilter() {
        return this.filter != null;
    }

    @Override
    public void start() {
        this.setStarting();
        if (this.filter != null) {
            this.filter.start();
        }
        this.setStarted();
    }

    @Override
    public void stop() {
        this.setStopping();
        if (this.filter != null) {
            this.filter.stop();
        }
        this.setStopped();
    }

    @Override
    public boolean isFiltered(LogEvent event) {
        return this.filter != null && this.filter.filter(event) == Filter.Result.DENY;
    }
}

