/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import com.google.common.base.Preconditions;
import io.netty.util.Recycler;
import io.protostuff.LinkedBuffer;

final class RecyclableLinkedBuffer
implements AutoCloseable {
    public static final int DEFAULT_BUFFER_SIZE = 512;
    public static final int DEFAULT_MAX_CAPACITY = 256;
    private LinkedBuffer buffer;
    private Recycler.Handle handle;
    private final Recycler<RecyclableLinkedBuffer> recycler;

    public RecyclableLinkedBuffer() {
        this(512, 256);
    }

    public RecyclableLinkedBuffer(final int bufferSize, int maxCapacity) {
        this.recycler = new Recycler<RecyclableLinkedBuffer>(maxCapacity){

            @Override
            protected RecyclableLinkedBuffer newObject(Recycler.Handle handle) {
                RecyclableLinkedBuffer wrapper = new RecyclableLinkedBuffer();
                wrapper.buffer = LinkedBuffer.allocate(bufferSize);
                wrapper.handle = handle;
                return wrapper;
            }
        };
    }

    public LinkedBuffer buffer() {
        Preconditions.checkState(this.buffer != null, "Call LinkedBufferWrapper.get() first");
        return this.buffer;
    }

    public RecyclableLinkedBuffer get() {
        return this.recycler.get();
    }

    public void release() {
        Preconditions.checkState(this.buffer != null, "Call LinkedBufferWrapper.get() first");
        this.buffer.clear();
        this.recycler.recycle(this, this.handle);
    }

    @Override
    public void close() {
        this.release();
    }
}

