/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import com.google.common.collect.ImmutableMap;
import io.protostuff.Input;
import io.protostuff.Output;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import io.scalecube.transport.Address;
import io.scalecube.transport.Message;
import io.scalecube.transport.RecyclableLinkedBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MessageSchema
implements Schema<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageSchema.class);
    private static final int HEADER_KEYS_FIELD_NUMBER = 1;
    private static final int HEADER_VALUES_FIELD_NUMBER = 2;
    private static final int DATA_FIELD_NUMBER = 3;
    private static final int SENDER_HOST_FIELD_NUMBER = 4;
    private static final int SENDER_PORT_FIELD_NUMBER = 5;
    private static final RecyclableLinkedBuffer recyclableLinkedBuffer = new RecyclableLinkedBuffer(256, 256);
    private static final Map<String, Integer> fieldMap = ImmutableMap.builder().put("headerKeys", 1).put("headerValues", 2).put("data", 3).put("senderHost", 4).put("senderPort", 5).build();
    private final Map<String, Optional<Class>> classCache = new ConcurrentHashMap<String, Optional<Class>>();

    MessageSchema() {
    }

    @Override
    public String getFieldName(int number) {
        switch (number) {
            case 1: {
                return "headerKeys";
            }
            case 2: {
                return "headerValues";
            }
            case 3: {
                return "data";
            }
            case 4: {
                return "senderHost";
            }
            case 5: {
                return "senderPort";
            }
        }
        return null;
    }

    @Override
    public int getFieldNumber(String name) {
        return fieldMap.get(name);
    }

    @Override
    public boolean isInitialized(Message message) {
        return message != null;
    }

    @Override
    public Message newMessage() {
        return new Message();
    }

    @Override
    public String messageName() {
        return Message.class.getSimpleName();
    }

    @Override
    public String messageFullName() {
        return Message.class.getName();
    }

    @Override
    public Class<? super Message> typeClass() {
        return Message.class;
    }

    @Override
    public void mergeFrom(Input input, Message message) throws IOException {
        boolean iterate = true;
        ArrayList<String> headerKeys = new ArrayList<String>();
        ArrayList<String> headerValues = new ArrayList<String>();
        String senderHost = null;
        int senderPort = 0;
        byte[] dataBytes = null;
        block10: while (iterate) {
            int number = input.readFieldNumber(this);
            switch (number) {
                case 0: {
                    iterate = false;
                    continue block10;
                }
                case 1: {
                    headerKeys.add(input.readString());
                    continue block10;
                }
                case 2: {
                    headerValues.add(input.readString());
                    continue block10;
                }
                case 3: {
                    dataBytes = input.readByteArray();
                    continue block10;
                }
                case 4: {
                    senderHost = input.readString();
                    continue block10;
                }
                case 5: {
                    senderPort = input.readInt32();
                    continue block10;
                }
            }
            input.handleUnknownField(number, this);
        }
        HashMap<String, String> headers = new HashMap<String, String>(headerKeys.size());
        if (!headerKeys.isEmpty()) {
            ListIterator headerValuesIterator = headerValues.listIterator();
            for (String key : headerKeys) {
                String value = (String)headerValuesIterator.next();
                headers.put(key, value);
            }
        }
        Object data = null;
        if (dataBytes != null) {
            String dataType = (String)headers.get("_type");
            if (dataType == null) {
                data = dataBytes;
            } else {
                Optional optionalDataClass = this.classCache.computeIfAbsent(dataType, this::classForName);
                if (optionalDataClass.isPresent()) {
                    headers.remove("_type");
                    Class dataClass = (Class)optionalDataClass.get();
                    Schema dataSchema = RuntimeSchema.getSchema(dataClass);
                    data = dataSchema.newMessage();
                    try {
                        ProtostuffIOUtil.mergeFrom(dataBytes, data, dataSchema);
                    }
                    catch (Throwable e) {
                        LOGGER.error("Failed to deserialize : {}", (Object)message);
                        throw e;
                    }
                } else {
                    data = dataBytes;
                }
            }
        }
        Address sender = senderHost != null ? Address.create(senderHost, senderPort) : null;
        message.setHeaders(headers);
        message.setData(data);
        message.setSender(sender);
    }

    @Override
    public void writeTo(Output output, Message message) throws IOException {
        Address sender;
        Object originalData;
        if (!message.headers().isEmpty()) {
            for (Map.Entry<String, String> headerEntry : message.headers().entrySet()) {
                if (headerEntry.getKey() == null || headerEntry.getValue() == null) continue;
                output.writeString(1, headerEntry.getKey(), true);
                output.writeString(2, headerEntry.getValue(), true);
            }
        }
        if ((originalData = message.data()) != null) {
            if (originalData instanceof byte[]) {
                output.writeByteArray(3, (byte[])originalData, false);
            } else {
                Class<?> dataClass = originalData.getClass();
                output.writeString(1, "_type", true);
                output.writeString(2, dataClass.getName(), true);
                Schema<?> dataSchema = RuntimeSchema.getSchema(dataClass);
                try (RecyclableLinkedBuffer rlb = recyclableLinkedBuffer.get();){
                    byte[] array = ProtostuffIOUtil.toByteArray(originalData, dataSchema, rlb.buffer());
                    output.writeByteArray(3, array, false);
                }
            }
        }
        if ((sender = message.sender()) != null) {
            output.writeString(4, sender.host(), false);
            output.writeInt32(5, sender.port(), false);
        }
    }

    private Optional<Class> classForName(String className) {
        try {
            Class<?> dataClass = Class.forName(className);
            return Optional.of(dataClass);
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }
}

