/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.scalecube.transport.NetworkEmulatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
final class ExceptionHandler
extends ChannelDuplexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionHandler.class);

    ExceptionHandler() {
    }

    @Override
    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof NetworkEmulatorException) {
            LOGGER.debug("Network emulator fire exception for channel {}: {}", (Object)ctx.channel(), (Object)cause.getMessage());
        } else {
            LOGGER.warn("Exception caught for channel {}, {}", ctx.channel(), cause.getMessage(), cause);
        }
    }
}

