/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import com.google.common.base.Throwables;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.SystemPropertyUtil;
import io.scalecube.transport.TransportConfig;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BootstrapFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BootstrapFactory.class);
    private static boolean envSupportEpoll;
    private final TransportConfig config;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;

    public BootstrapFactory(TransportConfig config) {
        this.config = config;
        this.bossGroup = this.createEventLoopGroup(config.getBossThreads(), new DefaultThreadFactory("sc-boss", true));
        this.workerGroup = this.createEventLoopGroup(config.getWorkerThreads(), new DefaultThreadFactory("sc-io", true));
    }

    public ServerBootstrap serverBootstrap() {
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(this.serverChannelClass())).childOption(ChannelOption.TCP_NODELAY, true).childOption(ChannelOption.SO_KEEPALIVE, true).childOption(ChannelOption.SO_REUSEADDR, true).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        return bootstrap;
    }

    public Bootstrap clientBootstrap() {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.workerGroup)).channel(this.channelClass())).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.config.getConnectTimeout())).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        return bootstrap;
    }

    private EventLoopGroup createEventLoopGroup(int threadNum, ThreadFactory threadFactory) {
        return this.isEpollSupported() ? new EpollEventLoopGroup(threadNum, threadFactory) : new NioEventLoopGroup(threadNum, threadFactory);
    }

    private Class<? extends ServerSocketChannel> serverChannelClass() {
        return this.isEpollSupported() ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
    }

    private Class<? extends SocketChannel> channelClass() {
        return this.isEpollSupported() ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    private boolean isEpollSupported() {
        return envSupportEpoll && this.config.isEnableEpoll();
    }

    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    public void shutdown() {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    static {
        String name = SystemPropertyUtil.get("os.name").toLowerCase(Locale.UK).trim();
        if (!name.contains("linux")) {
            envSupportEpoll = false;
            LOGGER.warn("Env doesn't support epoll transport");
        } else {
            try {
                Class.forName("io.netty.channel.epoll.Native");
                envSupportEpoll = true;
                LOGGER.info("Use epoll transport");
            }
            catch (Throwable t) {
                LOGGER.warn("Tried to use epoll transport, but it's not supported by host OS (or no corresponding libs included) using NIO instead, cause: " + Throwables.getRootCause(t));
                envSupportEpoll = false;
            }
        }
    }
}

