/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.scalecube.transport.Addressing;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Address {
    private static final Pattern ADDRESS_FORMAT = Pattern.compile("(?<host>^.*):(?<port>\\d+$)");
    private final String host;
    private final int port;

    private Address(@CheckForNull String host, int port) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(host));
        this.host = host;
        this.port = port;
    }

    public static Address from(@CheckForNull String hostAndPort) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(hostAndPort));
        Matcher matcher = ADDRESS_FORMAT.matcher(hostAndPort);
        if (!matcher.find()) {
            throw new IllegalArgumentException();
        }
        String host = matcher.group(1);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(host));
        String host1 = "localhost".equals(host) || "127.0.0.1".equals(host) ? Addressing.getLocalIpAddress().getHostAddress() : host;
        int port = Integer.parseInt(matcher.group(2));
        return new Address(host1, port);
    }

    public static Address create(String host, int port) {
        return new Address(host, port);
    }

    @Nonnull
    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Address that = (Address)other;
        return Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return this.host + ":" + this.port;
    }
}

